from spider import Spider, SpiderItemType, SpiderItem, SpiderSource, SpiderPlayURL
import os
import re
import json
import time
import html
import base64
import hashlib
import requests
import urllib.parse
import concurrent.futures
from bs4 import BeautifulSoup
from urllib.parse import urlparse
from proxy import get_proxy_url
from cache import get_cache, set_cache, del_cache
from utils import get_image_path, remove_html_tags
import xbmcaddon
import xbmcvfs

_ADDON = xbmcaddon.Addon()

localpath = _ADDON.getSettingString('user_path')
if localpath == '':
    localurl  = xbmcvfs.translatePath(os.path.join(_ADDON.getAddonInfo('path'), 'YSDQG.json'))
else:
    localurl  = xbmcvfs.translatePath(os.path.join(localpath, 'YSDQG.json'))
#localurl = 'YSDQG.json'

try:
    with open(localurl, 'r', encoding='utf-8') as f:
        data = f.read()
    jdata = json.loads(data.strip('\n'))
except Exception:
    jdata = {}

if 'YSDQ' in jdata and 'speedLimit' in jdata['YSDQ']:
    spLimit = jdata['YSDQ']['speedLimit']
else:
    spLimit = '1K'
if 'YSDQ' in jdata and 'thlimit' in jdata['YSDQ']:
    thlimit = jdata['YSDQ']['thlimit']
else:
    thlimit = 5

class SpiderZhiBo(Spider):

    def name(self):
        return '直播'

    def set_post(self):
        return True

    def is_searchable(self):
        return True

    def logo(self):
        return get_image_path('zhibo.png')

    def hide(self):
        return not _ADDON.getSettingBool('data_source_zhibo_switch')

    def list_items(self, parent_item=None, page=1):
        header = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"}
        if parent_item is None:
            items = []
            if 'Zhibo' in jdata and len(jdata['Zhibo']) != 0:
                for ids in jdata['Zhibo']:
                    name = ids['name']
                    pf = ids['pf']
                    id = ids['id']
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.Directory,
                            id=id,
                            name=name,
                            params={
                                'type': 'category',
                                'pf': pf,
                            },
                        ))
            else:
                items.append(
                    SpiderItem(
                        type=SpiderItemType.Directory,
                        id='208',
                        name='斗鱼-一起看',
                        params={
                            'type': 'category',
                            'pf': 'douyu',
                        },
                    ))
                items.append(
                    SpiderItem(
                        type=SpiderItemType.Directory,
                        id="2135",
                        name='虎牙-一起看',
                        params={
                            'type': 'category',
                            'pf': 'huya',
                        },
                    ))
                items.append(
                    SpiderItem(
                        type=SpiderItemType.Directory,
                        id="sport",
                        name='体育-全部',
                        params={
                            'type': 'category',
                            'pf': 'sport',

                        },
                    ))
            return items, False
        elif parent_item['params']['type'] == 'category':
            pf = parent_item['params']['pf']
            id = parent_item['id']
            if pf == 'douyu':
                url = 'https://www.douyu.com/gapi/rkc/directory/mixList/2_{}/{}'.format(id, page)
                r = requests.get(url)
                data = r.json()
                items = []
                for room in data['data']['rl']:
                    if room['type'] != 1:
                        continue
                    items.append(
                        SpiderItem(type=SpiderItemType.File,
                                   id=room['rid'],
                                   name=room['rn'],
                                   description='主播：{}\n在线人数：{}'.format(room['nn'],room['ol']),
                                   cover=room['rs1'],
                                   sources=[
                                       SpiderSource(
                                           room['rid'],
                                           {
                                               'pf': pf,
                                               'id': room['rid'],
                                           },
                                       )
                                   ]))
                return items, page < data['data']['pgcnt']
            elif pf == 'huya':
                header = {
                    "Connection": "keep-alive",
                    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36",
                    'Referer': 'https://www.huya.com/'
                }
                url = 'https://www.huya.com/cache.php?m=LiveList&do=getLiveListByPage&gameId={0}&tagAll=0&callback=getLiveListJsonpCallback&page={1}'.format(id, page)
                r = requests.get(url, headers=header)
                strjson = re.search(r"getLiveListJsonpCallback\((.*)\)", r.text).group(1)
                data = json.loads(strjson)
                items = []
                for room in data['data']['datas']:
                    items.append(
                        SpiderItem(type=SpiderItemType.Directory,
                                   id=room['profileRoom'],
                                   name=room['introduction'],
                                   description='主播：{}\n在线人数：{}'.format(room['nick'], room['totalCount']),
                                   cover=room['screenshot'],
                                   params={
                                       'type': 'video',
                                       'pf': pf,
                                   }
                                   ))
                return items, page < data['data']['totalPage']
            elif pf == 'bilibili':
                r = requests.get(
                    'https://api.live.bilibili.com/xlive/web-interface/v1/second/getList',
                    params={
                        'platform': 'web',
                        'parent_area_id': parent_item['id'],
                        'page': page,
                    })
                data = r.json()
                items = []
                for room in data['data']['list']:
                    items.append(
                        SpiderItem(type=SpiderItemType.File,
                                   id=room['roomid'],
                                   name=room['title'],
                                   description='主播：{}\n在线人数：{}'.format(room['uname'], room['online']),
                                   cover=room['cover'],
                                   sources=[
                                       SpiderSource(
                                           room['roomid'],
                                           {
                                               'pf': pf,
                                               'id': room['roomid'],
                                           },
                                       )
                                   ]))
                return items, data['data']['has_more']
            else:
                url = 'http://www.fifa2022.tv/'
                r = requests.get(url=url, headers=header, allow_redirects=False)
                soup = BeautifulSoup(r.content.decode('utf-8'), 'html.parser')
                data = soup.select('tr.against')
                cover = 'https://s1.ax1x.com/2022/10/07/x3NPUO.png'
                items = []
                for video in data:
                    infos = video.select('td')
                    urlList= video.select('td.live_link > a')
                    status = infos[3].select('div')
                    if status != []:
                        status = status[0].get_text()
                    else:
                        status = '未开始'
                    if '比分' not in urlList[0].get_text() and '结束' not in status:
                        stime = infos[2].get_text().strip()
                        gtype = infos[1].get_text().strip()
                        if len(infos) < 10:
                            hainfos = ' '.join(infos[4].get_text().lower().split()).split()
                            if hainfos.count('vs') != 0:
                                vsposi = hainfos.index('vs')
                                home = hainfos[vsposi - 1].strip()
                                away = hainfos[vsposi + 1].strip()
                                vs = 'VS'
                            else:
                                home = hainfos[0].strip()
                                vs = ''
                                away = ''
                        else:
                            home = infos[4].get_text().strip()
                            vs = 'VS'
                            away = infos[6].get_text().strip()
                        name = '[{}]{}{}{}'.format(stime, home, vs, away)
                        desc = '开播时间：{}\n赛事：{}' .format(stime, gtype)
                        sources = []
                        for url in urlList:
                            title = url.get_text()
                            aurl = url.get('href')
                            if '比分' not in title:
                                sources.append(
                                    SpiderSource(
                                        title,
                                        {
                                            'pf': pf,
                                            'url': aurl,
                                        },
                                    ))
                        items.append(
                            SpiderItem(
                                type=SpiderItemType.File,
                                name=name,
                                cover=cover,
                                description=desc,
                                sources=sources,
                                params={
                                    'speedtest': spLimit,
                                    'thlimit': thlimit,
                                }
                            ))
            has_next_page = False
            return items, has_next_page
        elif parent_item['params']['type'] == 'video':
            items = []
            if parent_item['params']['pf'] == 'huya':
                url = 'https://www.huya.com/' + parent_item['id']
                header = {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.77 Safari/537.36'
                }
                r = requests.get(url, headers=header)
                streamInfo = re.findall(r'stream: ([\s\S]*?)\n', r.text)
                if (len(streamInfo) > 0):
                    liveData = json.loads(streamInfo[0])
                else:
                    streamInfo = re.findall(r'"stream": "([\s\S]*?)"', r.text)
                    if (len(streamInfo) > 0):
                        liveDataBase64 = streamInfo[0]
                        liveData = json.loads(str(base64.b64decode(liveDataBase64), 'utf-8'))
                streamInfoList = liveData['data'][0]['gameStreamInfoList']
                sources = []
                for streamInfo in streamInfoList:
                    hls_url = streamInfo['sHlsUrl'] + '/' + streamInfo['sStreamName'] + '.' + streamInfo['sHlsUrlSuffix']
                    srcAntiCode = html.unescape(streamInfo['sHlsAntiCode'])
                    c = srcAntiCode.split('&')
                    c = [i for i in c if i != '']
                    n = {i.split('=')[0]: i.split('=')[1] for i in c}
                    fm = urllib.parse.unquote(n['fm'])
                    u = base64.b64decode(fm).decode('utf-8')
                    hash_prefix = u.split('_')[0]
                    ctype = n.get('ctype', '')
                    txyp = n.get('txyp', '')
                    fs = n.get('fs', '')
                    t = n.get('t', '')
                    seqid = str(int(time.time() * 1e3 + 1463993859134))
                    wsTime = hex(int(time.time()) + 3600).replace('0x', '')
                    hash = hashlib.md5('_'.join([hash_prefix, '1463993859134', streamInfo['sStreamName'], hashlib.md5((seqid + '|' + ctype + '|' + t).encode('utf-8')).hexdigest(), wsTime]).encode('utf-8')).hexdigest()
                    ratio = ''
                    purl = "{}?wsSecret={}&wsTime={}&seqid={}&ctype={}&ver=1&txyp={}&fs={}&ratio={}&u={}&t={}&sv=2107230339".format(hls_url, hash, wsTime, seqid, ctype, txyp, fs, ratio, '1463993859134', t)
                    sources.append(
                        SpiderSource(
                            streamInfo['sCdnType'],
                            {
                                'id': purl,
                                'pf': parent_item['params']['pf']
                            },
                        ))
                items.append(
                    SpiderItem(type=SpiderItemType.File,
                               id=parent_item['id'],
                               name=parent_item['name'],
                               description=parent_item['description'],
                               cover=parent_item['cover'],
                               sources=sources,
                               params={
                                   'speedtest': spLimit,
                                   'thlimit': thlimit,
                               }
                               ))
            else:
                items.append(
                    SpiderItem(type=SpiderItemType.File,
                               id=parent_item['id'],
                               name=parent_item['name'][3:],
                               cover=parent_item['cover'],
                               sources=parent_item['sources']))
            return items, False


    def resolve_play_url(self, source_params):
        header = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"}
        pf = source_params['pf']
        if pf == 'douyu':
            purl = 'http://epg.112114.xyz/douyu/{}'.format(source_params['id'])
            return SpiderPlayURL(purl)
        elif pf == 'huya':
            header = {
                "Connection": "keep-alive",
                "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36",
                'Referer': 'https://www.huya.com/'
            }
            purl = source_params['id']
            return SpiderPlayURL(
                get_proxy_url(
                    SpiderZhiBo.__name__,
                    self.proxy_video.__name__,
                    {
                        'url': purl,
                        'headers': header,
                    },
                ))
        elif pf =='bilibili':
            #url = 'https://api.live.bilibili.com/xlive/web-room/v2/index/getRoomPlayInfo?room_id={0}&protocol=0,1&format=0,1,2&codec=0,1'.format(id)
            url = 'https://api.live.bilibili.com/room/v1/Room/playUrl?cid={0}&qn=20000&platform=h5'.format(source_params['id'])
            r = requests.get(url=url, headers=header)
            data = r.json()['data']
            purl = data['durl'][0]['url']
            return SpiderPlayURL(purl)
        elif pf == 'sport':
            return SpiderPlayURL(source_params['url'])

    def proxy_video(self, ctx, params):
        url = params['url']
        headers = params['headers'].copy()
        self.proxy(ctx, url, headers)

    def search(self, keyword, page=1):
        items = []
        strsws = "bb,dy,hy"
        if page > 1:
            strsws = get_cache('zbstrsws')
            del_cache('zbstrsws')
        sws = strsws.split(',')
        contents = []
        keyword = keyword.replace('/', '%2F')
        with concurrent.futures.ThreadPoolExecutor(max_workers=thlimit) as executor:
            searchList = []
            try:
                for sw in sws:
                    num = sws.index(sw)
                    tag = sw
                    api = ''
                    future = executor.submit(self.runSearch, keyword, tag, page, num, api)
                    searchList.append(future)
                for future in concurrent.futures.as_completed(searchList, timeout=10):  # 并发执行
                    contents.append(future.result())
            except Exception:
                executor.shutdown(wait=False)
        nextpageList = []
        for content in contents:
            key = list(content.keys())[0]
            infos = content[key]
            items = items + content[key][0]
            nextpageList.append(infos[1])
            if not infos[1]:
                strsws = strsws.replace(key, '').replace(',,', ',').strip(',')
        set_cache('zbstrsws', strsws)
        if True in nextpageList:
            has_next_page = True
        else:
            has_next_page = False
        return items, has_next_page

    def runSearch(self, keyword, tag, page, num, api):
        try:
            funList = dir(SpiderZhiBo)
            defname = 'self.search' + tag
            if defname.replace('self.', '') in funList and tag != '':
                result = eval(defname)(keyword, tag, page, num, api)
                return result
        except Exception:
            return {tag: [[], False]}

    def searchbb(self, keyword, tag, page, num, api):
        r = requests.get(
            'https://api.bilibili.com/x/web-interface/search/type',
            params={
                'page': page,
                'page_size': 10,
                'order': 'online',
                'search_type': 'live_user',
                'keyword': keyword,
            },
            headers={'Cookie': 'buvid3=0'})
        data = r.json()
        if page < data['data']['numPages']:
            nexpage = True
        else:
            nexpage = False
        items = []
        for room in data['data']['result']:
            remark = remove_html_tags(room['cate_name'])
            if remark == '':
                remark = '其他'
            items.append(
                SpiderItem(type=SpiderItemType.Directory,
                           id=room['roomid'],
                           name='B站：{}'.format(remove_html_tags(room['uname'])),
                           cover='https:' + room['uface'],
                           description='类型：' + remark,
                           params={
                               'pf': 'bilibili',
                               'type': 'video',
                               'num': num
                           },
                           sources=[
                               SpiderSource(
                                   room['roomid'],
                                   {
                                       'id': room['roomid'],
                                       'pf': 'bilibili',
                                       'num': num
                                   },
                               )
                           ]))
        return {tag: [items, nexpage]}

    def searchdy(self, keyword, tag, page, num, api):
        r = requests.get('https://www.douyu.com/japi/search/api/searchUser',
                         params={
                             'kw': keyword,
                             'page': page,
                             'pageSize': 10,
                             'filterType': 1
                         })
        data = r.json()
        if page * 10 < data['data']['total']:
            nexpage = True
        else:
            nexpage = False
        items = []
        for room in data['data']['relateUser']:
            if room['anchorInfo']['isLive'] != 1:
                continue
            items.append(
                SpiderItem(type=SpiderItemType.Directory,
                           id=room['anchorInfo']['rid'],
                           name='斗鱼：{}'.format(room['anchorInfo']['nickName']),
                           description='主播：' + room['anchorInfo']['cateName'],
                           cover=room['anchorInfo']['roomSrc'],
                           params={
                               'pf': 'douyu',
                               'type': 'video',
                               'num': num
                           },
                           sources=[
                               SpiderSource(
                                   room['anchorInfo']['rid'],
                                   {
                                       'id': room['anchorInfo']['rid'],
                                       'pf': 'douyu',
                                       'num': num
                                   },
                               )
                           ]))
        return {tag: [items, nexpage]}

    def searchhy(self, keyword, tag, page, num, api):
        r = requests.get('https://search.cdn.huya.com/',
                         params={
                             'm': 'Search',
                             'do': 'getSearchContent',
                             'typ': -5,
                             'livestate': 1,
                             'q': keyword,
                             'start': (page-1)*40,
                             'rows': 40
                         })
        data = r.json()
        if page * 40 < data['response']['1']['numFound']:
            nexpage = True
        else:
            nexpage = False
        items = []
        for room in data['response']['1']['docs']:
            items.append(
                SpiderItem(type=SpiderItemType.Directory,
                           id=room['room_id'],
                           name='虎牙：{}'.format(room['game_nick']),
                           description='类型：' + room['game_name'],
                           cover=room['game_avatarUrl180'],
                           params={
                               'pf': 'huya',
                               'type': 'video',
                               'num': num
                           },
                           sources=[
                               SpiderSource(
                                   room['room_id'],
                                   {
                                       'id': room['room_id'],
                                       'pf': 'huya',
                                       'num': num
                                   },
                               )
                           ]))
        return {tag: [items, nexpage]}

    def checkPurl(self, source_params, tag):
        try:
            if source_params['pf'] == 'huya':
                header = {
                    "Connection": "keep-alive",
                    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36",
                    'Referer': 'https://www.huya.com/'
                }
                tspDict = self.readM3U8(source_params['id'], header, tag)
                return [tspDict, source_params['id']]
            else:
                url = source_params['url']
                headers = {
                    "Referer": url,
                    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"
                }
                r = requests.get(url)
                soup = BeautifulSoup(r.content.decode('utf-8'), 'html.parser')
                rurl = soup.select('div.media > iframe ')[0].get('src')
                r = requests.get(rurl, headers=headers, cookies=r.cookies)
                if 'm3u8' in r.text:
                    if 'm3u8.html?id=' in r.text:
                        purl = re.search(r'm3u8\.html\?id=(.*?m3u8.*?)\"',
                                         r.text.replace("\n", '').replace("\r", '')).group(1)
                    else:
                        purl = re.search(r"url: \'(.*?)\'", r.text.replace("\n", '').replace("\r", '')).group(1)
                    if not purl.startswith('http'):
                        purl = re.search(r"(.*)/", rurl).group(1) + purl
                    tspDict = self.readM3U8(purl, headers, tag)
                    return [tspDict, purl]
                else:
                    aurl = re.search(r"(.*)/", rurl).group(1) + re.search(r'src=\"..(.*?)\"', r.text.replace("\n", '').replace("\r", '')).group(1)
                    aheaders = {
                        "Referer": rurl,
                        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"
                    }
                    r = requests.get(aurl, headers=aheaders, cookies=r.cookies)
                    purl = re.search(r"url: \'(.*?)\'", r.text.replace("\n", '').replace("\r", ''))
                    if purl == None:
                        purl = re.search(r'm3u8\.html\?id=(.*?)\"', r.text.replace("\n", '').replace("\r", ''))
                    purl = purl.group(1)
                    tspDict = self.readM3U8(purl, {}, tag)
                    return [tspDict, purl]
        except Exception as e:
            print(e)
            return [{tag: 0}, '']

    def sub(self, string, p, c):
        new = []
        for s in string:
            new.append(s)
        new[p] = c
        return ''.join(new)

    def readM3U8(self, url, header, tag):
        if '.xs' in url or '.flv' in url or '.mp4' in url or '.jpg' in url or '.jepg' in url or '.bmp' in url or '.png' in url or '.ico' in url or '.icon' in url or '###' in url:
           return self.SpeedInfo(url.replace('###', ''), header, tag)
        s_url = None
        try:
            if '@@@' in url:
                url = url.split('@@@')[0]
                response = requests.get(url, headers=header, allow_redirects=False, verify=False, timeout=5)
                if 'Location' in response.headers and response.text == '':
                    url = response.headers['Location']
                    response = requests.get(url, headers=header, allow_redirects=False, verify=False, timeout=5)
            else:
                response = requests.get(url, headers=header, verify=False, timeout=5)
            response.encoding = 'utf-8'
            str = response.text
            result = urlparse(url)
            url_tou = result[0] + '://' + result[1]
            # 获取m3u8中的片段ts文件
            # 需要替换 ../
            list = str.split("\n");
            for str in list:
                if str.find(".ts") != -1 or str.find(".jpg") != -1 or str.find(".jepg") != -1 or str.find(".ico") != -1 or str.find(".icon") != -1 or str.find(".bmp") != -1 or str.find(".png") != -1:
                    # 特殊格式==>回退目录
                    if str.find("../../../../..") != -1:
                        s_url = str.replace("../../../../..", url_tou)
                    # 普通格式，直接替换，如果ts文件的开头是/则表示根目录
                    else:
                        if str[0:1] == '/':
                            s_url = self.sub(str, 0, url_tou + "/").strip('\r').strip('\n').strip()
                        elif str.startswith('http'):
                            s_url = str.strip('\r').strip('\n').strip()
                        else:
                            pos = url.rfind("/")
                            s_url = url.replace(url[pos:], "/" + str).strip('\r').strip('\n').strip()
                    break
                elif str.find(".m3u") != -1:
                    if str[0:1] == '/':
                        s_url = self.sub(str, 0, url_tou + "/").strip('\r').strip('\n').strip()
                    elif str.startswith('http'):
                        s_url = str.strip('\r').strip('\n').strip()
                    else:
                        pos = url.rfind("/")
                        s_url = url.replace(url[pos:], "/" + str).strip('\r').strip('\n').strip()
                    return self.readM3U8(s_url, header, tag)
            return self.SpeedInfo(s_url, header, tag)
        except Exception as e:
            return {tag: 0}

    def SpeedInfo(self, url, header, tag):
        header.update({'Proxy-Connection':'keep-alive'})
        r = requests.get(url, stream=True, headers=header, verify=False, timeout=5)
        count = 0
        count_tmp = 0
        stime = time.time()
        i = 0
        speed = 0
        for chunk in r.iter_content(chunk_size=1024):
            if chunk:
                if i != 0 :
                    break
                count += len(chunk)
                sptime = time.time() - stime
                if sptime > 0:
                    speed = int((count - count_tmp) / sptime)
                    stime = time.time()
                    i = i + 1
        return {tag: speed}

#if __name__ == '__main__':
    #spider = SpiderZhiBo()
    #res = spider.list_items(parent_item={'type': 'directory', 'id': '11342412', 'name': '【周星星】星爷经典不间断', 'cover': 'http://live-cover.msstatic.com/huyalive/1394575534-1394575534-5989656310331736064-2789274524-10057-A-0-1/20230202211336.jpg?x-oss-process=style/w338_h190&streamName=1394575534-1394575534-5989656310331736064-2789274524-10057-A-0-1&interval=10', 'description': '主播：周星星\n在线人数：1090511', 'cast': [], 'director': '', 'area': '', 'year': 0, 'sources': [], 'danmakus': [], 'subtitles': [], 'params': {'type': 'video', 'pf': 'huya'}}, page=1)
    #res = spider.resolve_play_url({'id': 'http://al.flv.huya.com/src/1394575534-1394575534-5989656310331736064-2789274524-10057-A-0-1.flv?wsSecret=6879aebef5b7edca82c314280f98e302&wsTime=63dd14c2&fm=RFdxOEJjSjNoNkRKdDZUWV8kMF8kMV8kMl8kMw%3D%3D&ctype=tars_mobile&txyp=o%3Aqzeic1%3B&fs=bgct&sphdcdn=al_7-tx_3-js_3-ws_7-bd_2-hw_2&sphdDC=huya&sphd=264_*-265_*&exsphd=264_500,264_2000,264_4000,264_8000,&t=103', 'pf': 'huya'})
    #res = spider.checkPurl({'pf': 'huya', 'id': '11342412'}, '2')
    #res = spider.search('超级', 1)
    #res = spider.runSearch('超级', 'hy', 1, 3, '')
    #print(res)