from spider import Spider, SpiderItemType, SpiderSource, SpiderDanmaku, SpiderItem, SpiderPlayURL
from spider_aliyundrive import SpiderAliyunDrive
import os
import re
import time
import json
import base64
import urllib
import difflib
import hashlib
import requests
import concurrent.futures
from bs4 import BeautifulSoup
from proxy import get_proxy_url
from urllib.parse import urlparse
from danmaku import get_danmaku_url, get_m3u8_url
from cache import get_cache, set_cache, del_cache
from utils import get_image_path, remove_html_tags, cleanText
import xbmcaddon
import xbmcvfs

_ADDON = xbmcaddon.Addon()

base_params = {
    'pcode': '010110005',
    'version': '2.1.2',
    'devid': hashlib.md5(str(time.time()).encode()).hexdigest(),
    'sys': 'android',
    'sysver': 12,
    'brand': 'Redmi',
    'model': 'M2104K10AC',
    'package': 'android.bugly.qq.com'
}
base_headers = {
    'User-Agent': 'Dalvik/2.1.0 (Linux; U; Android 12; M2104K10AC Build/SP1A.210812.016)',
}

try:
    bbexists = True
    from spider_bilibili import Spiderbilibili
except Exception:
    bbexists = False

localpath = _ADDON.getSettingString('user_path')
if localpath == '':
    localurl  = xbmcvfs.translatePath(os.path.join(_ADDON.getAddonInfo('path'), 'YSDQG.json'))
else:
    localurl  = xbmcvfs.translatePath(os.path.join(localpath, 'YSDQG.json'))
bbhide = Spiderbilibili.hide(Spiderbilibili())

#bbhide = False
#localurl = 'YSDQG.json'

try:
    with open(localurl, 'r', encoding='utf-8') as f:
        data = f.read()
    jdata = json.loads(data.strip('\n'))
except Exception:
    jdata = {}

if 'YSDQ' in jdata and 'speedLimit' in jdata['YSDQ']:
    spLimit = jdata['YSDQ']['speedLimit']
else:
    spLimit = '1K'
if 'YSDQ' in jdata and 'thlimit' in jdata['YSDQ']:
    thlimit = jdata['YSDQ']['thlimit']
else:
    thlimit = 5

class Spideryingshi(Spider):

    def name(self):
        return '影视'

    def logo(self):
        return get_image_path('yingshi.png')

    def hide(self):
        return not _ADDON.getSettingBool('data_source_yingshi_switch')

    def set_post(self):
        return True

    def is_searchable(self):
        return True

    def list_items(self, parent_item=None, page=1):
        if parent_item is None:
            items = []
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id='recommend',
                    name='高分电影',
                    params={
                        'type': 'category',
                        'pf': 'db'
                    },
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id='hot_gaia',
                    name='电影',
                    params={
                        'type': 'category',
                        'pf': 'db'
                    },
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id='剧集',
                    name='剧集',
                    params={
                        'type': 'category',
                        'pf': 'db'
                    },
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id='show_hot',
                    name='综艺',
                    params={
                        'type': 'category',
                        'pf': 'db'
                    },
                ))
            return items, False
        elif parent_item['params']['type'] == 'category':
            if parent_item['params']['pf'] == 'db':
                items = []
                header = {
                    "Host": "frodo.douban.com",
                    "Connection": "Keep-Alive",
                    "Referer": "https://servicewechat.com/wx2f9b06c1de1ccfca/84/page-frame.html",
                    "content-type": "application/json",
                    "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36 MicroMessenger/7.0.9.501 NetType/WIFI MiniProgramEnv/Windows WindowsWechat"
                }
                tag = parent_item['id']
                idname = parent_item['name']
                if idname == '剧集':
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.Directory,
                            id='tv_hot',
                            name='全部剧集',
                            params={
                                'type': 'category',
                                'pf': 'db'
                            },
                        ))
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.Directory,
                            id='tv_domestic',
                            name='国产剧',
                            params={
                                'type': 'category',
                                'pf': 'db'
                            },
                        ))
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.Directory,
                            id='tv_american',
                            name='美剧',
                            params={
                                'type': 'category',
                                'pf': 'db'
                            },
                        ))
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.Directory,
                            id='tv_japanese',
                            name='日剧',
                            params={
                                'type': 'category',
                                'pf': 'db'
                            },
                        ))
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.Directory,
                            id='tv_korean',
                            name='韩剧',
                            params={
                                'type': 'category',
                                'pf': 'db'
                            },
                        ))
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.Directory,
                            id='tv_animation',
                            name='动画',
                            params={
                                'type': 'category',
                                'pf': 'db'
                            },
                        ))
                    return items, False
                elif '电影' in idname:
                    url = 'https://frodo.douban.com/api/v2/movie/{}'.format(tag)
                    if tag == 'recommend':
                        params = {'tags': '', 'sort': 'T', 'refresh': 0, 'selected_categories': '{"类型":"","地区":""}', 'start': (int(page) - 1) * 30, 'count': 30, 'apikey': '0ac44ae016490db2204ce0a042db2916'}
                    elif tag == 'hot_gaia':
                        params = {'area': '全部', 'sort': 'recommend', 'start': ((int(page) - 1) * 30), 'count': 30, 'apikey': '0ac44ae016490db2204ce0a042db2916'}
                    r = requests.get(url, headers=header, params=params)
                    data = json.loads(cleanText(r.text))
                    append = 'items'
                elif idname in ['综艺', '动画', '日剧', '韩剧', '美剧', '国产剧', '全部剧集']:
                    url = 'https://frodo.douban.com/api/v2/subject_collection/{}/items'.format(tag)
                    params = {'start': (int(page) - 1) * 30, 'count': 30, 'apikey': '0ac44ae016490db2204ce0a042db2916'}
                    r = requests.get(url, headers=header, params=params)
                    data = json.loads(cleanText(r.text))
                    append = 'subject_collection_items'
                for video in data[append]:
                    vid = video['id']
                    voddesc = video['comment']
                    if type(voddesc) == dict:
                        voddesc = voddesc['comment']
                    cover = video['pic']['large']
                    name = video['title'].strip()
                    if '电影' in idname:
                        remark = video['rating']['value']
                        if remark != '':
                            remark = '{}分'.format(remark)
                        else:
                            remark = '暂无评分'
                    else:
                        remark = video['episodes_info']
                        if remark == '' and video['rating'] != None:
                            remark = video['rating']['value']
                            if remark != '':
                                remark = '{}分'.format(remark)
                        else:
                            remark = '暂无评分'
                    desc = '信息：{}\n简介：{}'.format(remark, remove_html_tags((voddesc).strip()))
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.Search,
                            name=remove_html_tags(name).strip(),
                            id=vid,
                            description=desc,
                            cover=cover,
                            params={
                                'pf': 'db'
                            },
                        ))
                if page * 30 < data['total']:
                    has_next_page = True
                else:
                    has_next_page = False
                return items, has_next_page
            else:
                return SpiderAliyunDrive.list_items(SpiderAliyunDrive(), parent_item, page)
        elif parent_item['params']['type'] == 'video':
            if parent_item['params']['pf'] == 'qq':
                ts = int(time.time())
                params = base_params.copy()
                params['ids'] = parent_item['id']
                params['sj'] = ts
                headers = base_headers.copy()
                headers['t'] = str(ts)
                url = 'http://api.kunyu77.com/api.php/provide/videoDetail'
                headers['TK'] = self._get_tk(url, params, ts)
                r = requests.get(url, params=params, headers=headers)
                detail = json.loads(cleanText(r.text))['data']
                url = 'http://api.kunyu77.com/api.php/provide/videoPlaylist'
                headers['TK'] = self._get_tk(url, params, ts)
                r = requests.get(url, params=params, headers=headers)
                episodes = json.loads(cleanText(r.text))['data']['episodes']
                items = []
                for episode in episodes:
                    sources = []
                    danmakus = []
                    for playurl in episode['playurls']:
                        sources.append(
                            SpiderSource(
                                playurl['playfrom'],
                                {
                                    'playfrom': playurl['playfrom'],
                                    'url': playurl['playurl'],
                                    'pf': 'qq'
                                },
                            ))
                        if playurl['playfrom'] in ['qq', 'mgtv', 'qiyi', 'youku', 'bilibili']:
                            if playurl['playfrom'] != 'bilibili':
                                danmu = playurl['playurl']
                            else:
                                r = requests.get(url=playurl['playurl'], headers=headers, timeout=5)
                                m = re.search(r'"cid":(.*?),', cleanText(r.text))
                                oid = m.group(1)
                                if not oid or oid == '0':
                                    m = re.search(r'bilivideo.com/upgcxcode/\d+/\d+(?:/(\d+)){2}', cleanText(r.text))
                                    oid = m.group(1)
                                danmu = 'bilibilidanmu' +oid
                            danmakus.append(
                                SpiderDanmaku(
                                    playurl['playfrom'],
                                    get_danmaku_url(danmu),
                                )
                            )
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.File,
                            name=remove_html_tags(episode['title']).strip(),
                            cover=detail['videoCover'],
                            description=remove_html_tags(detail['brief']).replace('\u3000', '').strip(),
                            cast=detail['actor'].replace(' ', '').split('/'),
                            director=detail['director'],
                            area=detail['area'].strip(),
                            year=int(detail['year'].strip()),
                            sources=sources,
                            danmakus=danmakus,
                            params={
                                'speedtest': spLimit,
                                'thlimit': thlimit,
                            }
                        ))
                return items, False
            if parent_item['params']['pf'] == 'ik':
                items = []
                header = {
                    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"
                }
                url = 'https://ikan6.vip/voddetail/{0}/'.format(parent_item['id'])
                r = requests.get(url, headers=header)
                soup = BeautifulSoup(cleanText(r.text), 'html.parser')
                cover = parent_item['cover']
                infos = soup.select('div.myui-content__detail > p.data')
                yainfo = infos[0].get_text().replace('\n\n', '\n').replace('\t', '').strip('\n').split('\n')
                year = int(yainfo[2].replace('年份：', ''))
                area = yainfo[1].replace('地区：', '')
                cast = infos[2].get_text().replace('主演：', '').strip('\xa0').split('\xa0')
                dire = infos[3].get_text().replace('导演：', '').replace('\xa0',',')
                desc = soup.select('div.col-pd.text-collapse.content > span.data')[0].get_text().replace('\n', '').replace('\u3000', '').replace('：', '').replace('详情', '').replace('\xa0', '').replace(' ', '')
                episinfos = soup.select('div.tab-content.myui-panel_bd > div')
                numepis = []
                episList = []
                titleInfos = []
                titleList = re.findall(r'<a href=\"#playlist\d\" data-toggle=\"tab\">(.*?)</a>', cleanText(r.text))
                i = 0
                for episinfo in episinfos:
                    lennp = len(episinfo.select('ul > li'))
                    numepis.append(lennp)
                    episList.append(episinfo.select('ul > li'))
                    titleInfos.append([lennp, titleList[i].strip()])
                    i = i + 1
                episList.sort(key=lambda i: len(i), reverse=True)
                titleInfos.sort(key=lambda i: (i)[0], reverse=True)
                maxepis = max(numepis)
                episodes = episList[0]
                a = 0
                b = 0
                for episode in episodes:
                    sources = []
                    i = 0
                    name = episode.select('a')[0].get_text().strip()
                    for epis in episList:
                        if i == 0:
                            k = a
                        else:
                            k = b
                        if k >= len(epis):
                            continue
                        if epis[k] == episode:
                            sepisode = episode
                        else:
                            sepisode = epis[b]
                        title = titleInfos[i][1]
                        sname = sepisode.select('a')[0].get_text().strip()
                        if len(sepisode) == maxepis or '1080P' in sname or 'HD' in sname or '正片' in sname or '国语' in sname or '粤语' in sname or '韩语' in sname or '英语' in sname or '中字' in sname:
                            ratio = 1
                        else:
                            ratio = difflib.SequenceMatcher(None, name, sname).ratio()
                        if ratio < 0.1 or '预告' in sname or '回顾' in sname:
                            b = b - 1
                            continue
                        purl = re.search(r'/vodplay/(.*?)/', sepisode.select('a')[0].get('href')).group(1)
                        sources.append(
                            SpiderSource(
                                title,
                                {
                                    'playfrom': '',
                                    'pf': 'ik',
                                    'url': purl,
                                },
                            ))
                        i = i + 1
                    a = a + 1
                    b = b + 1
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.File,
                            name=remove_html_tags(name).strip(),
                            cover=cover,
                            description=remove_html_tags(desc).strip(),
                            cast=cast,
                            director=dire,
                            area=area,
                            year=int(year),
                            sources=sources,
                            params={
                                'speedtest': spLimit,
                                'thlimit': thlimit,
                            }
                        ))
                return items, False
            if parent_item['params']['pf'] == 'T4':
                items = []
                header = {"User-Agent": "okhttp/3.12.11"}
                url = '{}?ac=detail&ids={}'.format(parent_item['params']['api'], parent_item['id'])
                r = requests.get(url,headers=header)
                jo = json.loads(cleanText(r.text))['list'][0]
                cover = jo['vod_pic']
                desc = remove_html_tags(jo['vod_content']).replace('\r', '').replace('&nbsp; ','').replace('\u3000','').strip()
                episinfos = jo['vod_play_url'].strip('$$$').split('$$$')
                numepis = []
                episList = []
                titleInfos = []
                titleList = jo['vod_play_from'].strip('$$$').split('$$$')
                i = 0
                for episinfo in episinfos:
                    lennp = len(episinfo.strip('#').split('#'))
                    numepis.append(lennp)
                    episList.append(episinfo.strip('#').split('#'))
                    titleInfos.append([lennp, titleList[i].strip()])
                    i = i + 1
                episList.sort(key=lambda i: len(i), reverse=True)
                titleInfos.sort(key=lambda i: i[0], reverse=True)
                maxepis = max(numepis)
                episodes = episList[0]
                a = 0
                b = 0
                for episode in episodes:
                    sources = []
                    i = 0
                    name = episode.strip('$').split('$')[0].strip()
                    for epis in episList:
                        if i == 0:
                            k = a
                        else:
                            k = b
                        if k >= len(epis):
                            continue
                        if epis[k] == episode:
                            sepisode = episode
                        else:
                            sepisode = epis[b]
                        title = titleInfos[i][1]
                        sname = sepisode.strip('$').split('$')[0].strip()
                        if len(sepisode) == maxepis or '1080P' in sname or 'HD' in sname or '正片' in sname or '国语' in sname or '粤语' in sname or '韩语' in sname or '英语' in sname or '中字' in sname:
                            ratio = 1
                        else:
                            n = re.search(r'(\d+)', name)
                            if n:
                                n = int(n.group(1))
                            else:
                                n = name
                            s = re.search(r'(\d+)', sname)
                            if s:
                                s = int(s.group(1))
                            else:
                                s = sname
                            ratio = difflib.SequenceMatcher(None, str(n), str(s)).ratio()
                        if ratio < 0.1 or '预告' in sname or '回顾' in sname:
                            b = b - 1
                            continue
                        purl = sepisode.strip('$').split('$')[1].strip()
                        sources.append(
                            SpiderSource(
                                title,
                                {
                                    'playfrom': title,
                                    'pf': 'T4',
                                    'url': purl,
                                    'api': parent_item['params']['api']
                                },
                            ))
                        i = i + 1
                    a = a + 1
                    b = b + 1
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.File,
                            name=remove_html_tags(name).strip(),
                            cover=cover,
                            description=desc,
                            sources=sources,
                            params={
                                'speedtest': spLimit,
                                'thlimit': thlimit,
                            }
                        ))
                return items, False
            if parent_item['params']['pf'] == 'ps':
                if not parent_item['id'].startswith('http'):
                    header = {
                        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36',
                        'Referer': 'https://www.alipansou.com' + '/s/' + parent_item['id']
                    }
                    r = requests.get('https://www.alipansou.com' + '/cv/' + parent_item['id'], allow_redirects=False, headers=header)
                    url = re.search(r'href=\"(.*)\"', cleanText(r.text)).group(1)
                    parent_item['id'] = url
                return SpiderAliyunDrive.list_items(SpiderAliyunDrive(), parent_item, page)
            if parent_item['params']['pf'] == 'ys' or parent_item['params']['pf'] == 'xzt':
                return SpiderAliyunDrive.list_items(SpiderAliyunDrive(), parent_item, page)
            if parent_item['params']['pf'] == 'zzy':
                regex_url = re.compile(r'https://www.aliyundrive.com/s/[^"]+')
                if not hasattr(self, 'zzy'):
                    cookie = self.getCookie('zzy')
                else:
                    cookie = self.zzyck
                r = requests.get('https://zhaoziyuan.la/' + parent_item['id'], cookies=cookie)
                m = regex_url.search(cleanText(r.text))
                url = m.group().replace('\\', '')
                parent_item['id'] = url
                return SpiderAliyunDrive.list_items(SpiderAliyunDrive(), parent_item, page)
            if parent_item['params']['pf'] == 'ali':
                return SpiderAliyunDrive.list_items(SpiderAliyunDrive(), parent_item, page)
            if bbexists is True and parent_item['params']['pf'] == '影视':
                return Spiderbilibili.list_items(Spiderbilibili(), parent_item, page)
        else:
            return [], False

    def resolve_play_url(self, source_params):
        if not source_params['pf'] in ['ali', '影视']:
            return SpiderPlayURL(source_params['url'])
        if source_params['pf'] == 'ali':
            return SpiderAliyunDrive.resolve_play_url(SpiderAliyunDrive(), source_params)
        if bbexists is True and source_params['pf'] == '影视':
            return Spiderbilibili.resolve_play_url(Spiderbilibili(), source_params)

    def checkPurl(self, source_params, tag):
        try:
            if source_params['pf'] == 'qq':
                headers = {}
                qqurl = source_params['url']
                if source_params['playfrom'] != 'ppayun':
                    if 'QiQi' in jdata and 'jx' in jdata['QiQi'][0] and 'gs' in jdata['QiQi'][0] and 'erro' in jdata['QiQi'][0]:
                        jxinfos = jdata['QiQi']
                        for jxinfo in jxinfos:
                            jx = jxinfo['jx']
                            if '{}' in jx:
                                if 'info' in dir():
                                    jx = jx.format(info)
                                else:
                                    parse = urlparse(jx)
                                    parseinfos = parse.path.strip('/').split('/')
                                    url = '{}://{}/config/{}/{}/0'.format(parse.scheme, parse.netloc, parseinfos[2], parseinfos[3])
                                    r = requests.get(url)
                                    jo = json.loads(cleanText(r.text).replace('/*', '').replace('*/', ''))['sites']
                                    for j in jo:
                                        if parse.netloc in j['api']:
                                            parse = urlparse(j['api'])
                                            parseinfos = parse.path.strip('/').split('/')
                                            info = parseinfos[0]
                                            jx = jx.format(info)
                                            break
                            gs = jxinfo['gs'].strip().split(',')
                            erro = jxinfo['erro']
                            jurl = jx + qqurl
                            if 'header' in jxinfo:
                                headers = {"User-Agent": jxinfo['header']}
                            r = requests.get(jurl, headers=headers)
                            if erro in cleanText(r.text) and erro != '':
                                continue
                            qqurl = json.loads(cleanText(r.text))
                            for i in range(0, len(gs)):
                                qqurl = qqurl[gs[i]]
                            if qqurl != '':
                                break
                    else:
                        return [{tag: 0}, '']
                tspList = self.readM3U8(qqurl, headers, tag)
                purl = tspList[1]
                tspDict = tspList[0]
                if tspList[2] == 'proxy':
                    purl = get_proxy_url(Spideryingshi.__name__, self.proxy_m3u8.__name__,
                                         {'url': purl, 'headers': headers})
                return [tspDict, purl]
            if source_params['pf'] == 'ik':
                header = {
                    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36",
                    "Referer": "https://ikan6.vip/"
                }
                url = 'https://ikan6.vip/vodplay/{0}/'.format(source_params['url'])
                r = requests.get(url, verify=False, headers=header)
                cookie = r.cookies
                info = json.loads(re.search(r'var player_data=(.*?)</script>', cleanText(r.text)).group(1))
                string = info['url'][8:len(info['url'])]
                substr = base64.b64decode(string).decode('UTF-8')
                str = substr[8:len(substr) - 8]
                if 'Ali' in info['from']:
                    url = 'https://cms.ikan6.vip/ali/nidasicaibudaowozaina/nicaibudaowozaina.php?url={0}'.format(str)
                else:
                    url = 'https://cms.ikan6.vip/nidasicaibudaowozaina/nicaibudaowozaina.php?url={0}'.format(str)
                r = requests.get(url, verify=False, headers=header, cookies=cookie)
                randomurl = re.search(r"getrandom\(\'(.*?)\'", cleanText(r.text)).group(1)
                pstring = randomurl[8:len(randomurl)]
                psubstr = base64.b64decode(pstring).decode('UTF-8')
                purl = urllib.parse.unquote(psubstr[8:len(psubstr) - 8])
                pheader = {
                    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"
                }
                if 'Ali' in info['from']:
                    tspList = self.readM3U8(purl, pheader, tag)
                    tspDict = tspList[0]
                    purl = tspList[1]
                    return [tspDict, purl]
                else:
                    tspList = self.readM3U8(purl, header, tag)
                    purl = tspList[1]
                    tspDict = tspList[0]
                    purl = get_proxy_url(Spideryingshi.__name__, self.proxy_m3u8.__name__, {'url': purl, 'headers': header})
                    return [tspDict, purl]
            if source_params['pf'] == 'T4':
                header = {"User-Agent": "okhttp/3.12.11"}
                if 'http://' in source_params['url'] or 'https://' in source_params['url']:
                    purl = source_params['url']
                else:
                    url = '{}?play={}&flag={}'.format(source_params['api'], source_params['url'], source_params['playfrom'])
                    r = requests.get(url, headers=header)
                    jo = json.loads(cleanText(r.text))
                    purl = jo['url']
                    if 'jx' in jo and jo['jx'] == '1':
                        if '://v.qq.com/' in purl or '://v.youku.com/' in purl or '://www.mgtv.com/' in purl or '://www.iqiyi.com/' in purl:
                            tag = tag + "@@@" + jo['url']
                        elif '://www.bilibili.com/' in purl:
                            r = requests.get(url=purl, headers=header, timeout=5)
                            m = re.search(r'"cid":(.*?),', cleanText(r.text))
                            oid = m.group(1)
                            if not oid or oid == '0':
                                m = re.search(r'bilivideo.com/upgcxcode/\d+/\d+(?:/(\d+)){2}', cleanText(r.text))
                                oid = m.group(1)
                            danmu = 'bilibilidanmu' + oid
                            tag = tag + "@@@" + danmu
                        if 'QiQi' in jdata:
                            jxinfos = jdata['QiQi']
                            for jxinfo in jxinfos:
                                if 'jx' not in jxinfo or 'gs' not in jxinfo or 'erro' not in jxinfo:
                                    continue
                                jx = jxinfo['jx']
                                if '{}' in jx:
                                    parse = urlparse(source_params['api'])
                                    parseinfos = parse.path.strip('/').split('/')
                                    jx = jx.format(parseinfos[0])
                                gs = jxinfo['gs'].strip().split(',')
                                erro = jxinfo['erro']
                                jurl = jx + jo['url']
                                if 'header' in jxinfo:
                                    header = {"User-Agent": jxinfo['header']}
                                r = requests.get(jurl, headers=header)
                                if erro in cleanText(r.text) and erro != '':
                                    continue
                                purl = json.loads(cleanText(r.text))
                                for i in range(0, len(gs)):
                                    purl = purl[gs[i]]
                                if purl != '':
                                    break
                tspList = self.readM3U8(purl, header, tag)
                purl = tspList[1]
                tspDict = tspList[0]
                if tspList[2] == 'proxy':
                    purl = get_proxy_url(Spideryingshi.__name__, self.proxy_m3u8.__name__, {'url': purl, 'headers': header})
                return [tspDict, purl]
        except Exception:
            return [{tag: 0}, '']

    def sub(self, string, p, c):
        new = []
        for s in string:
            new.append(s)
        new[p] = c
        return ''.join(new)

    def readM3U8(self, url, header, tag):
        url = url.strip('/')
        if '@@@' in url:
            url = url.split('@@@')[0]
        m3u8List = []
        s_url = ''
        ts_url = ''
        ads = []
        try:
            response = requests.get(url, headers=header, stream=True, allow_redirects=False, verify=False, timeout=5)
            if 'video' in response.headers['Content-Type']:
                response.close()
                return self.SpeedInfo(url, header, tag, url)
            if 'Location' in response.headers and '#EXTM3U' not in response.text:
                url = response.headers['Location']
                response.close()
                response = requests.get(url, headers=header, allow_redirects=False, verify=False, timeout=5)
            response.encoding = 'utf-8'
            str = response.text
            result = urlparse(url)
            url_tou = result[0] + '://' + result[1]
            # 获取m3u8中的片段ts文件
            # 需要替换 ../
            list = str.split("\n");
            for str in list:
                ostr = ''
                if str.find(".ts") != -1 or str.find(".jpg") != -1 or str.find(".jepg") != -1 or str.find(".ico") != -1 or str.find(".icon") != -1 or str.find(".bmp") != -1 or str.find(".png") != -1 or str.find("EXT-X-KEY") != -1:
                    if "EXT-X-KEY" in str:
                        ostr = str
                        str = re.search(r'URI=(.*)', str).group(1).replace('"', '').strip().split(',')[0]
                        URI = str
                    # 特殊格式==>回退目录
                    if str.find("../../../../..") != -1:
                        s_url = str.replace("../../../../..", url_tou)
                    # 普通格式，直接替换，如果ts文件的开头是/则表示根目录
                    else:
                        if str[0:1] == '/':
                            s_url = self.sub(str, 0, url_tou + "/").strip('\r').strip('\n').strip()
                        elif str.startswith('http'):
                            s_url = str.strip('\r').strip('\n').strip()
                        else:
                            pos = url.rfind("/")
                            s_url = url.replace(url[pos:], "/" + str).strip('\r').strip('\n').strip()
                    if ts_url == '' and '.key' not in s_url:
                        ts_url = s_url
                    if ostr != '':
                        s_url = ostr.replace(URI, s_url)
                elif str.find(".m3u") != -1:
                    if str[0:1] == '/':
                        s_url = self.sub(str, 0, url_tou + "/").strip('\r').strip('\n').strip()
                    elif str.startswith('http'):
                        s_url = str.strip('\r').strip('\n').strip()
                    else:
                        pos = url.rfind("/")
                        s_url = url.replace(url[pos:], "/" + str).strip('\r').strip('\n').strip()
                    return self.readM3U8(s_url, header, tag)
                elif str.startswith("http"):
                    s_url = str
                    if ts_url == '':
                        ts_url = s_url
                if 'YSDQ' in jdata and 'ads' in jdata['YSDQ']:
                    ads = jdata['YSDQ']['ads']
                if str.startswith('#'):
                    s_url = str
                m3u8List.append(s_url)
                if urlparse(s_url)[1] in ads:
                     del m3u8List[-2:]
                #if 'EXT-X-DISCONTINUITY' in str:
                    #m3u8List.pop()
            m3u8List.pop()
            m3u8str = "\n".join(m3u8List)
            del_cache('m3u8')
            set_cache('m3u8', m3u8str.strip('\n'))
            url = get_m3u8_url()
            return self.SpeedInfo(ts_url, header, tag, url)
        except Exception:
            return {tag: 0}

    def SpeedInfo(self, url, header, tag, purl):
        header.update({'Proxy-Connection':'keep-alive'})
        r = requests.get(url, stream=True, headers=header, verify=False, timeout=5)
        count = 0
        count_tmp = 0
        stime = time.time()
        i = 0
        speed = 0
        proxy = 'nomral'
        for chunk in r.iter_content(chunk_size=40960):
            if chunk:
                if i == 2:
                    break
                count += len(chunk)
                sptime = time.time() - stime
                if chunk.startswith(b'\xFF\xD8\xFF\xE0\x00\x10\x4A\x46\x49\x46') or chunk.startswith(b'\x89\x50\x4E\x47\x0D\x0A\x1A\x0A') or chunk.startswith(b'\x42\x4D'):
                    proxy = 'proxy'
                if count == int(r.headers['content-length']):
                    speed = int((count - count_tmp) / sptime)
                if sptime > 0:
                    speed = int((count - count_tmp)/sptime)
                    stime = time.time()
                    count_tmp = count
                    i = i + 1
        return [{tag: speed}, purl, proxy]

    def search(self, keyword, page=1):
        items = []
        if 'YSDQ' in jdata and 'searchList' in jdata['YSDQ']:
            strsws = jdata['YSDQ']['searchList'].strip().strip(',').strip('\n')
        else:
            strsws ="qq,ik,bb,ps,ys,zzy,xzt"
        if 'YSDQ' in jdata and 'T4api' in jdata['YSDQ']:
            T4List = jdata['YSDQ']['T4api']
            for TL in T4List:
                if '{}' in TL['api']:
                    if 'info' in dir():
                        TL['api'] = TL['api'].format(info)
                        continue
                    parse = urlparse(TL['api'])
                    parseinfos = parse.path.strip('/').split('/')
                    url = '{}://{}/config/{}/{}/0'.format(parse.scheme, parse.netloc,parseinfos[1], parseinfos[2])
                    r = requests.get(url)
                    jo = json.loads(cleanText(r.text).replace('/*', '').replace('*/', ''))['sites']
                    for j in jo:
                        if parse.netloc in j['api']:
                            parse = urlparse(j['api'])
                            parseinfos = parse.path.strip('/').split('/')
                            info = parseinfos[0]
                            TL['api'] = TL['api'].format(info)
                            break
        if 'YSDQ' in jdata and 'CJapi' in jdata['YSDQ']:
            CJList = jdata['YSDQ']['CJapi']
        if page > 1:
            strsws = get_cache('strsws')
            del_cache('strsws')
        sws = strsws.split(',')
        if 'T4List' in dir() and page == 1:
            sws = T4List + sws
        if 'CJList' in dir() and page == 1:
            sws = CJList + sws
        if bbhide is True or bbexists is False:
            if 'bb' in sws:
                sws.remove('bb')
        contents = []
        keyword = keyword.replace('/', '%2F')
        with concurrent.futures.ThreadPoolExecutor(max_workers=thlimit) as executor:
            searchList = []
            try:
                for sw in sws:
                    num = sws.index(sw)
                    if type(sw) is dict:
                        tag = 'T4'
                        api = '{}@@@{}'.format(sw['name'], sw['api'])
                    else:
                        tag = sw
                        api = ''
                    future = executor.submit(self.runSearch, keyword, tag, page, num, api)
                    searchList.append(future)
                for future in concurrent.futures.as_completed(searchList, timeout=10):  # 并发执行
                    contents.append(future.result())
            except Exception:
                executor.shutdown(wait=False)
        nextpageList = []
        for content in contents:
            key = list(content.keys())[0]
            infos = content[key]
            items = items + content[key][0]
            nextpageList.append(infos[1])
            if not infos[1]:
                strsws = strsws.replace(key, '').replace(',,', ',').strip(',')
        if True in nextpageList:
            has_next_page = True
        else:
            has_next_page = False
        set_cache('strsws',strsws)
        items.sort(key=lambda i: i['params']['num'], reverse=False)
        return items, has_next_page

    def runSearch(self, keyword, tag, page, num, api):
        try:
            funList = dir(Spideryingshi)
            defname = 'self.search' + tag
            if defname.replace('self.', '') in funList and tag != '':
                result = eval(defname)(keyword, tag, page, num, api)
            return result
        except Exception:
            return {tag: [[], False]}

    def searchqq(self, keyword, tag, page, num, api):
        items = []
        url = 'http://api.kunyu77.com/api.php/provide/searchVideo'
        ts = int(time.time())
        params = base_params.copy()
        params['sj'] = ts
        params['searchName'] = keyword
        params['pg'] = page
        headers = base_headers.copy()
        headers['t'] = str(ts)
        headers['TK'] = self._get_tk(url, params, ts)
        r = requests.get(url, params=params, headers=headers, timeout=5)
        jo = json.loads(cleanText(r.text))
        data = jo['data']
        if len(data) == 20:
            nexpage = True
        else:
            nexpage = False
        for video in data:
            remark = video['msg'].strip()
            if remark == '':
                remark = 'HD'
            voddesc = remove_html_tags(video['brief']).replace('\r', '').replace('&nbsp; ','').replace('\u3000','').strip()
            desc = '信息：{}\n简介：{}'.format(remark.strip(), voddesc)
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    name='七七：{}'.format(remove_html_tags(video['videoName']).strip()),
                    id=video['id'],
                    cover=video['videoCover'],
                    description=desc,
                    cast=video['starName'].replace(' ','').replace('声优','').replace(':',',').replace('：',',').replace(' ',',').strip(',').split(','),
                    params={
                        'type': 'video',
                        'pf': 'qq',
                        'num': num
                    },
                ))
        return {tag: [items, nexpage]}

    def searchik(self, keyword, tag, page, num, api):
        items = []
        header = {
            "User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36"
        }
        url = 'https://ikan6.vip/vodsearch/-------------/?wd={0}&submit='.format(keyword)
        verifyCode, session = self.verifyCode('https://ikan6.vip/index.php/verify/index.html?', 'https://ikan6.vip/index.php/ajax/verify_check?type=search&verify=')
        if verifyCode is False:
            return {tag: [items, False]}
        if not session:
            return {tag: [items, False]}
        r = session.get(url, headers=header, timeout=5)
        soup = BeautifulSoup(cleanText(r.text), 'html.parser')
        data = soup.select('ul#searchList > li')
        for video in data:
            sid = re.search(r'/voddetail/(.*?)/', video.find('a').get('href')).group(1)
            name = video.find('h4').get_text().strip()
            cover = video.select('div.thumb > a')[0].get('data-original')
            remark = video.select('div.thumb > a')[0].get_text().strip().strip('\n').split('\n')[-1].strip()
            voddesc = video.select('div.detail > p')[3].get_text().replace('简介：', '').replace('详情 >', '')
            desc = '信息：{}\n简介：{}'.format(remark, remove_html_tags(voddesc).strip())
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    name='爱看：{}'.format(remove_html_tags(name)),
                    id=sid,
                    cover=cover,
                    description=desc,
                    params={
                        'type': 'video',
                        'pf': 'ik',
                        'num': num
                    },
                ))
        return {tag: [items, False]}

    def searchT4(self, keyword, tag, page, num, api):
        items = []
        header = {"User-Agent": "okhttp/3.12.11"}
        apis = api.split('@@@')
        tag = apis[0]
        api = apis[1].strip('/')
        url = '{}?wd={}&ac=detail'.format(api, urllib.parse.quote(keyword))
        r = requests.get(url, headers=header, timeout=5)
        jo = json.loads(cleanText(r.text))
        vodList = jo['list']
        for vod in vodList:
            aid = vod['vod_id']
            title = vod['vod_name'].strip()
            img = vod['vod_pic']
            desc = remove_html_tags(vod['vod_remarks']).strip()
            if desc == '':
                desc = 'HD'
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    name='{}：{}'.format(tag, title),
                    id=aid,
                    description='信息：' + desc,
                    cover=img,
                    params={
                        'type': 'video',
                        'pf': 'T4',
                        'api': api,
                        'num': num
                    },
                ))

        return {tag: [items, False]}

    def searchbb(self, keyword, tag, page, num, api):
        items = []
        url = 'https://api.bilibili.com/x/web-interface/search/type?search_type=media_bangumi&keyword={0}'.format(keyword)
        if not hasattr(self, 'bbck'):
            cookie = self.getCookie('bb')
        else:
            cookie = self.bbck
        r = requests.get(url, cookies=cookie, timeout=5)
        jo = json.loads(cleanText(r.text))
        if jo['data']['numResults'] != 0:
            vodList = jo['data']['result']
            for vod in vodList:
                aid = str(vod['season_id']).strip()
                title = remove_html_tags(vod['title']).strip()
                img = vod['eps'][0]['cover'].strip()
                desc = remove_html_tags(vod['index_show']).strip()
                items.append(
                    SpiderItem(
                        type=SpiderItemType.Directory,
                        name='哔哩影视：{}'.format(title),
                        id=aid,
                        description='信息：' + desc,
                        cover=img,
                        params={
                            'type': 'video',
                            'pf': '影视',
                            'num': num
                        },
                    ))
        return {tag: [items, False]}

    def searchps(self, keyword, tag, page, num, api):
        items = []
        r = requests.get('https://www.alipansou.com/search', params={'k': keyword, 't': 7}, timeout=5)
        soup = BeautifulSoup(cleanText(r.text), 'html.parser')
        rows = soup.select('van-row > a')
        for row in rows:
            desc = re.search(r'时间: (.*?) ', str(row.get_text)).group(1)
            clean = re.compile('<.*?>')
            name = re.sub(clean, '', row.find('template').__str__()).replace('\n', '').replace('\t', '').replace(' ', '')
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    name='阿里盘搜：{}'.format(remove_html_tags(name).strip()),
                    description='更新时间：' + remove_html_tags(desc).strip(),
                    id=re.search(r'/s/(.*)', row.get('href')).group(1),
                    params={
                        'type': 'video',
                        'pf': 'ps',
                        'num': num
                    }
                ))
        return {tag: [items, False]}

    def searchys(self, keyword, tag, page, num, api):
        items = []
        header = {
            "User-Agent": "Mozilla/5.0 (Linux; Android 12; V2049A Build/SP1A.210812.003; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/103.0.5060.129 Mobile Safari/537.36",
            "Referer": "https://yiso.fun/"
        }
        url = "https://yiso.fun/api/search?name={0}&from=ali".format(keyword)
        r = requests.get(url=url, headers=header, timeout=5)
        jo = json.loads(cleanText(r.text))
        elements = jo["data"]["list"]
        for element in elements:
            id = element["url"]
            name = element["fileInfos"][0]["fileName"]
            desc = element['gmtCreate'].split(' ')[0]
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id=id,
                    name='阿里易搜：{}'.format(remove_html_tags(name).strip()),
                    description='更新时间：' + remove_html_tags(desc).strip(),
                    params={
                        'type': 'video',
                        'pf': 'ys',
                        'num': num
                    }
                ))
        return {tag: [items, False]}

    def searchzzy(self, keyword, tag, page, num, api):
        items = []
        if not hasattr(self, 'zzy'):
            cookie = self.getCookie('zzy')
        else:
            cookie = self.zzyck
        r = requests.get('https://zhaoziyuan.la/so', params={'filename': keyword}, cookies=cookie, timeout=5)
        soup = BeautifulSoup(cleanText(r.text), 'html.parser')
        elements = soup.select('div.news_text > a')
        for element in elements:
            name = element.find('h3')
            if name is None:
                return {tag: [items, False]}
            else:
                name = element.find('h3').text
                desc = element.find('p').text.split('|')[-1].split('：')[1].split(' ')[0].strip()
                items.append(
                    SpiderItem(
                        type=SpiderItemType.Directory,
                        id=element.get('href'),
                        name='阿里找资源：{}'.format(remove_html_tags(name).strip()),
                        description='更新时间：' + remove_html_tags(desc).strip(),
                        params={
                            'type': 'video',
                            'pf': 'zzy',
                            'num': num
                        }
                    ))
        return {tag: [items, False]}

    def searchxzt(self, keyword, tag, page, num, api):
        items = []
        r = requests.post('https://gitcafe.net/tool/alipaper/', data={'action': 'search', 'keyword': keyword}, timeout=5)
        data = json.loads(cleanText(r.text))
        for video in data:
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id='https://www.aliyundrive.com/s/' + video['key'],
                    name='阿里小纸条：' + remove_html_tags(video['title']).strip(),
                    params={
                        'type': 'video',
                        'pf': 'xzt',
                        'num': num
                    }
                ))
        return {tag: [items, False]}

    def getCookie(self, tag):
        if tag == 'zzy':
            header = {
                "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.54 Safari/537.36",
                "Referer": "https://zhaoziyuan.la/login.html",
                "Origin": "https://zhaoziyuan.la/"
            }
            if 'Zhaozy' in jdata:
                logininfo = {'username': jdata['Zhaozy']['username'], 'password': jdata['Zhaozy']['password']}
                r = requests.post('https://zhaoziyuan.la/logiu.html', data=logininfo, headers=header, timeout=5)
                self.zzyck = r.cookies
                return r.cookies
        if tag =='bb':
            r = requests.get("https://www.bilibili.com/")
            self.bbck = r.cookies
            return r.cookies

    def getDanm(self, oid):
        header = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.54 Safari/537.36"
        }
        r = requests.get('https://api.bilibili.com/x/v1/dm/list.so', params={'oid': oid}, headers=header, timeout=5)
        danmu = re.search(r'<?xml version.*?</source>(.*)</i>', r.content.decode())
        if danmu:
            danmu = danmu.group(1)
        else:
            danmu = ''
        set_cache('bilibilidanmu' + oid, danmu)
        return danmu

    def verifyCode(self, imgurl, resurl):
        if 'YSDQ' in jdata and 'ocrurl' in jdata['YSDQ']:
            ocrurl = jdata['YSDQ']['ocrurl']
        else:
            return False, None
        retry = 5
        header = {
            "User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36"
        }
        while retry:
            try:
                session = requests.session()
                img = session.get(imgurl, headers=header).content
                code = session.post(url=ocrurl, data=base64.b64encode(img).decode()).text
                res = session.post(url="{}{}".format(resurl, code), headers=header).json()
                if res["msg"] == "ok":
                    return True, session
            except Exception as e:
                print(e)
            finally:
                retry = retry - 1
        return False, None

    def _get_tk(self, url, params, ts):
        keys = []
        for key in params:
            keys.append(key)
        keys.sort()
        src = urlparse(url).path
        for key in keys:
            src += str(params[key])
        src += str(ts)
        src += 'XSpeUFjJ'
        return hashlib.md5(src.encode()).hexdigest()

    def proxy_m3u8(self, ctx, params):
        url = params['url']
        redirects = ''
        if '@@@' in url:
            infos = url.split('@@@')
            url = infos[0]
            redirects = infos[1]
        headers = params['headers'].copy()
        if redirects == 'False':
            r = requests.get(url, headers=headers, stream=True, verify=False, allow_redirects=False)
        else:
            r = requests.get(url, headers=headers, stream=True, verify=False)
        content_type = r.headers['Content-Type'] if 'Content-Type' in r.headers else ''
        if content_type.startswith('image/') or content_type.startswith('text/'):
            content_type = 'application/vnd.apple.mpegurl'
        r.headers['Content-Type'] = content_type
        try:
            ctx.send_response(r.status_code)
            for key in r.headers:
                if key.lower() in ['connection', 'transfer-encoding']:
                    continue
                if content_type.lower() == 'application/vnd.apple.mpegurl':
                    if key.lower() in ['content-length', 'content-range']:
                        continue
                ctx.send_header(key, r.headers[key])
            ctx.end_headers()
            if 'application/vnd.apple.mpegurl' in content_type.lower():
                for line in r.iter_lines(8192):
                    line = line.decode()
                    if len(line) > 0 and not line.startswith('#'):
                        if not line.startswith('http'):
                            if line.startswith('/'):
                                line = url[:url.index('/', 8)] + line
                            else:
                                line = url[:url.rindex('/') + 1] + line
                        line = get_proxy_url(
                            Spideryingshi.__name__,
                            self.proxy_ts.__name__,
                            {
                                'url': line,
                                'headers': params['headers'],
                            },
                        )
                    ctx.wfile.write((line + '\n').encode())
            else:
                for chunk in r.iter_content(8192):
                    ctx.wfile.write(chunk)
        except Exception as e:
            print(e)
        finally:
            try:
                r.close()
            except:
                pass

    def proxy_ts(self, ctx, params):
        url = params['url']
        headers = params['headers'].copy()
        for key in ctx.headers:
            if key.lower() in ['user-agent', 'host']:
                continue
            headers[key] = ctx.headers[key]
        r = requests.get(url, headers=headers, stream=True, verify=False)
        r.headers['Content-Type'] = 'video/MP2T'

        try:
            ctx.send_response(r.status_code)
            for key in r.headers:
                if key.lower() in ['connection', 'transfer-encoding', 'accept-ranges']:
                    continue
                ctx.send_header(key, r.headers[key])
            ctx.end_headers()
            stripped_image_header = False
            for chunk in r.iter_content(8192):
                if not stripped_image_header:
                    chunk = chunk.lstrip(b'\xFF\xD8\xFF\xE0\x00\x10\x4A\x46\x49\x46')
                    chunk = chunk.lstrip(b'\x89\x50\x4E\x47\x0D\x0A\x1A\x0A')
                    chunk = chunk.lstrip(b'\x42\x4D\x5A\x27\x4C')
                    chunk = chunk.lstrip(b'\x42\x4D')
                    stripped_image_header = True
                ctx.wfile.write(chunk)
        except Exception as e:
            print(e)
        finally:
            try:
                r.close()
            except:
                pass

#if __name__ == '__main__':
    #spider = Spideryingshi()
    #res = spider.list_items(parent_item= None, page=1)
    #res = spider.getDanm("https%3A%2F%2Fwww.bilibili.com%2Fbangumi%2Fplay%2Fep718240")
    #res = spider.search('显微镜下的大明之丝绢案', page=1)
    #res = spider.checkPurl({},'1')
    #res = spider.proxy_m3u8('ctx', {'url': 'http://t.grelighting.cn/m3u8/OUVjQnA5cHdPQ0pTMFp2RmpFc0JHL2JFV2tLU1hpQ1U=.m3u8', 'headers': {'User-Agent': 'okhttp/3.12.11', 'Proxy-Connection': 'keep-alive'}})
    #res = spider.runSearch('狂飙', 'ps', 1, 3, '')
    #res = spider.getCookie('zzy')
    #print(res)