from spider import Spider, SpiderItemType, SpiderSource, SpiderItem, SpiderPlayURL
import os
import re
import json
import time
import requests
from bs4 import BeautifulSoup
from danmaku import get_m3u8_url
from utils import get_image_path
from urllib.parse import urlparse
import xbmcaddon
import xbmcvfs

_ADDON = xbmcaddon.Addon()

localpath = _ADDON.getSettingString('user_path')
if localpath == '':
    localurl  = xbmcvfs.translatePath(os.path.join(_ADDON.getAddonInfo('path'), 'YSDQG.json'))
else:
    localurl  = xbmcvfs.translatePath(os.path.join(localpath, 'YSDQG.json'))

#localurl = 'YSDQG.json'

try:
    with open(localurl, 'r', encoding='utf-8') as f:
        data = f.read()
    jdata = json.loads(data.strip('\n'))
except Exception:
    jdata = {}

if 'YSDQ' in jdata and 'speedLimit' in jdata['YSDQ']:
    spLimit = jdata['YSDQ']['speedLimit']
else:
    spLimit = '1K'
if 'YSDQ' in jdata and 'thlimit' in jdata['YSDQ']:
    thlimit = jdata['YSDQ']['thlimit']
else:
    thlimit = 5
if 'YSDQ' in jdata and 'disableIPV6' in jdata['YSDQ']:
    disableIPV6 = jdata['YSDQ']['disableIPV6']
else:
    disableIPV6 = 'yes'

class SpiderDianShiZhiBo(Spider):

    def name(self):
        return '电视直播'

    def logo(self):
        return get_image_path('dianshi.png')

    def set_post(self):
        return False

    def is_searchable(self):
        return True

    def hide(self):
        return not _ADDON.getSettingBool('data_source_dianshi_switch')

    def list_items(self, parent_item=None, page=1):
        header = {
            "User-Agent": "Mozilla/5.0 (Linux; U; Android 9; zh-cn; MIX 2S Build/PKQ1.180729.001) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.128 Mobile Safari/537.36 XiaoMi/MiuiBrowser/10.1.1"}
        if parent_item is None:
            items = []
            r = requests.get('https://cjk.lm317379829.repl.co/CJK/ITV.json', headers=header)
            datas = json.loads(r.text)
            for data in datas.keys():
                name = data
                id = data
                str = json.dumps(datas[data], ensure_ascii=False)
                items.append(
                    SpiderItem(
                        type=SpiderItemType.Directory,
                        name=name.replace('网络', '数字频道'),
                        id=id,
                        params={
                            'type': 'category',
                            'str': str
                        },
                    ))
            #items.sort(key=lambda i: len(i['name']), reverse=False)
            return items, False
        elif parent_item['params']['type'] == 'category':
            data = json.loads(parent_item['params']['str'])
            items = []
            for video in data:
                cover = 'https://epg.112114.xyz/logo/{}.png'.format(video)
                items.append(
                    SpiderItem(
                        type=SpiderItemType.Directory,
                        id=video,
                        name=video,
                        cover=cover,
                        params={
                            'type': 'video',
                        },
                    ))
            return items, False
        elif parent_item['params']['type'] == 'video':
            items = []
            header = {
                "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"
            }
            url = 'https://cjk.lm317379829.repl.co/IPTV/?page={}&s={}'.format(page,  parent_item['id'])
            r = requests.get(url, headers=header)
            soup = BeautifulSoup(r.content, 'html.parser')
            data = soup.select('table.tables > tr')
            mpg = soup.select('div[style="display:flex;justify-content:center;"] > a')
            if mpg != []:
                maxpage = int(re.search(r'page=(.*?)&', mpg[-1].get('href')).group(1))
            else:
                maxpage = 1
            nameList = []
            for video in data:
                strvideo = video.get_text().replace('\r', '').replace('\n', '').replace('\t', '')
                if strvideo == '':
                    continue
                infos = strvideo.split('checked')
                name = re.search(r'(.*?)\d\d-\d+-\d+', infos[0]).group(1)
                purl = infos[1].strip()
                if not purl.startswith('http'):
                    continue
                if name in nameList:
                    num = nameList.index(name)
                    sources = (
                        SpiderSource(
                            'Checked ' + re.search(r'\d+-\d+-\d+', infos[0]).group(0).strip(),
                            {
                                'url': purl,
                             }
                        ))
                    items[num]['sources'].append(sources)
                else:
                    nameList.append(name)
                    sources = []
                    sources.append(
                        SpiderSource(
                            'Checked ' + re.search(r'\d+-\d+-\d+', infos[0]).group(0).strip(),
                            {
                                'url': purl,
                            },
                        ))
                    items.append(
                        SpiderItem(
                            type=SpiderItemType.File,
                            name=name,
                            id='',
                            cover=parent_item['cover'],
                            description='',
                            sources=sources,
                            params={
                                'speedtest': spLimit,
                                'thlimit': thlimit,
                            }
                        ))
            if page < maxpage:
                has_next_page = True
            else:
                has_next_page = False
            return items, has_next_page
        else:
            return [], False

    def resolve_play_url(self, source_params):
        return SpiderPlayURL(source_params['url'])

    def search(self, keyword, page=1):
        items = []
        header = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"
        }
        url = 'https://cjk.lm317379829.repl.co/IPTV/?page={}&s={}'.format(page, keyword)
        r = requests.get(url, headers=header)
        soup = BeautifulSoup(r.content, 'html.parser')
        data = soup.select('table.tables > tr')
        mpg = soup.select('div[style="display:flex;justify-content:center;"] > a')
        if mpg != []:
            maxpage = int(re.search(r'page=(.*?)&', mpg[-1].get('href')).group(1))
        else:
            maxpage = 1
        nameList= []
        for video in data:
            strvideo = video.get_text().replace('\r','').replace('\n','').replace('\t','')
            if strvideo == '':
                continue
            infos = strvideo.split('checked')
            name = re.search(r'(.*?)\d\d-\d+-\d+', infos[0]).group(1)
            purl = infos[1].strip()
            if not purl.startswith('http'):
                continue
            if name in nameList:
                num = nameList.index(name)
                sources = (SpiderSource('Checked ' + re.search(r'\d+-\d+-\d+', infos[0]).group(0).strip(),
                        {
                            'url': purl
                        }))
                items[num]['sources'].append(sources)
            else:
                nameList.append(name)
                sources = []
                sources.append(
                    SpiderSource(
                        'Checked ' + re.search(r'\d+-\d+-\d+', infos[0]).group(0).strip(),
                        {
                            'url': purl

                        },
                    ))
                items.append(
                    SpiderItem(
                        type=SpiderItemType.File,
                        name='电视直播：{}'.format(name),
                        id='',
                        cover='',
                        description='',
                        sources=sources,
                        params={
                            'speedtest': spLimit,
                            'thlimit': thlimit,
                        }
                    ))
        if page < maxpage:
            has_next_page = True
        else:
            has_next_page = False
        return items, has_next_page

    def checkPurl(self, source_params, tag):
        header = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"
        }
        purl = source_params['url']
        try:
            if not purl.endswith('/') and purl.count('/') == 2:
                purl = purl + '/'
            num = re.search(r'://(.*?)/', purl).group(1).count(":")
            if disableIPV6.lower() == 'yes' and num > 4:
                return [{tag: 0}, '']
            r = requests.get(purl, stream=True, allow_redirects=False, headers=header, timeout=5)
            if 'Content-Type' in r.headers and 'video' in r.headers['Content-Type'].lower():
                r.close()
            if 'Location' in r.headers:
                purl = r.headers['Location']
            tspList = self.readM3U8(purl, header, tag)
            purl = tspList[1]
            tspDict = tspList[0]
            return [tspDict, purl]
        except Exception:
            return [{tag: 0}, purl]

    def sub(self, string, p, c):
        new = []
        for s in string:
            new.append(s)
        new[p] = c
        return ''.join(new)

    def readM3U8(self, url, header, tag):
        url = url.strip('/')
        if '@@@' in url:
            url = url.split('@@@')[0]
        ts_url = ''
        try:
            response = requests.get(url, headers=header, stream=True, allow_redirects=False, verify=False, timeout=5)
            if 'video' in response.headers['Content-Type']:
                response.close()
                return self.SpeedInfo(url, header, tag, url)
            if 'Location' in response.headers and '#EXTM3U' not in response.text:
                url = response.headers['Location']
                response.close()
                response = requests.get(url, headers=header, allow_redirects=False, verify=False, timeout=5)
            response.encoding = 'utf-8'
            str = response.text
            result = urlparse(url)
            url_tou = result[0] + '://' + result[1]
            # 获取m3u8中的片段ts文件
            # 需要替换 ../
            list = str.split("\n");
            for str in list:
                ostr = ''
                if str.find(".ts") != -1 or str.find(".jpg") != -1 or str.find(".jepg") != -1 or str.find(".ico") != -1 or str.find(".icon") != -1 or str.find(".bmp") != -1 or str.find(".png") != -1 or str.find("EXT-X-KEY") != -1:
                    if "EXT-X-KEY" in str:
                        ostr = str
                        str = re.search(r'URI=(.*)', str).group(1).replace('"', '').strip().split(',')[0]
                        URI = str
                    # 特殊格式==>回退目录
                    if str.find("../../../../..") != -1:
                        s_url = str.replace("../../../../..", url_tou)
                    # 普通格式，直接替换，如果ts文件的开头是/则表示根目录
                    else:
                        if str[0:1] == '/':
                            s_url = self.sub(str, 0, url_tou + "/").strip('\r').strip('\n').strip()
                        elif str.startswith('http'):
                            s_url = str.strip('\r').strip('\n').strip()
                        else:
                            pos = url.rfind("/")
                            s_url = url.replace(url[pos:], "/" + str).strip('\r').strip('\n').strip()
                    if ts_url == '' and '.key' not in s_url:
                        ts_url = s_url
                elif str.find(".m3u") != -1:
                    if str[0:1] == '/':
                        s_url = self.sub(str, 0, url_tou + "/").strip('\r').strip('\n').strip()
                    elif str.startswith('http'):
                        s_url = str.strip('\r').strip('\n').strip()
                    else:
                        pos = url.rfind("/")
                        s_url = url.replace(url[pos:], "/" + str).strip('\r').strip('\n').strip()
                    return self.readM3U8(s_url, header, tag)
                elif str.startswith("http"):
                    s_url = str.strip('\r').strip('\n').strip()
                    if ts_url == '':
                        ts_url = s_url
            return self.SpeedInfo(ts_url, header, tag, url)
        except Exception:
            return {tag: 0}

    def SpeedInfo(self, url, header, tag, purl):
        header.update({'Proxy-Connection':'keep-alive'})
        r = requests.get(url, stream=True, headers=header, verify=False, timeout=5)
        count = 0
        count_tmp = 0
        stime = time.time()
        i = 0
        speed = 0
        proxy = 'nomral'
        for chunk in r.iter_content(chunk_size=40960):
            if chunk:
                if i == 2:
                    break
                count += len(chunk)
                sptime = time.time() - stime
                if chunk.startswith(b'\xFF\xD8\xFF\xE0\x00\x10\x4A\x46\x49\x46') or chunk.startswith(b'\x89\x50\x4E\x47\x0D\x0A\x1A\x0A') or chunk.startswith(b'\x42\x4D'):
                    proxy = 'proxy'
                if count == int(r.headers['content-length']):
                    speed = int((count - count_tmp) / sptime)
                if sptime > 0:
                    speed = int((count - count_tmp)/sptime)
                    stime = time.time()
                    count_tmp = count
                    i = i + 1
        return [{tag: speed}, purl, proxy]

#if __name__ == '__main__':
    #spider = SpiderDianShiZhiBo()
    #res = spider.list_items(parent_item={'type': 'directory', 'id': '央视', 'name': '央视', 'cover': '', 'description': '', 'cast': [], 'director': '', 'area': '', 'year': 0, 'sources': [], 'danmakus': [], 'subtitles': [], 'params': {'type': 'category', 'str': '["CCTV1", "CCTV2", "CCTV3", "CCTV4", "CCTV5", "CCTV6", "CCTV7", "CCTV8", "CCTV9", "CCTV10", "CCTV11", "CCTV12", "CCTV13", "CCTV14", "CCTV15", "CCTV16", "CCTV17", "CCTV4K", "CCTV5+", "CGTN", "CGTN俄语", "CGTN法语", "CGTN西语", "CGTN阿语", "CCTV4欧洲", "CCTV4美洲", "CHC动作电影", "CHC家庭影院", "CHC高清电影", "CGTNDOCUMENTARY", "IPTV5+", "IPTV6+", "IPTV少儿动画", "IPTV热播剧场", "IPTV经典电影", "IPTV魅力时尚", "中国交通", "中国天气", "中国教育1", "中国教育2", "中国教育3", "中国教育4", "央广健康", "央视台球", "央视精品"]'}}, page=1)
    #res = spider.resolve_play_url({'url': 'http://[2409:8087:3869:8021:1001::e5]:6610/PLTV/88888888/224/3221225918/2/index.m3u8?IASHttpSessionId=OTT15232820230107121543310379'}})
    #res = spider.search("CCTV1", 1)
    #res = spider.checkPurl({'url': 'http://111.20.33.93/TVOD/88888888/224/3221225804/index.m3u8'}, '3')
    #print(res)