# -*- coding: utf-8 -*-
import xbmc, xbmcgui
import sys, simplejson
from module.plus import getString

# 编码
if sys.getdefaultencoding() != 'utf-8':
	reload(sys)
	sys.setdefaultencoding('utf-8')

# 主程序
set_id = sys.argv[1]
movies = simplejson.loads(xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "Files.GetDirectory", "params": {"directory": "videodb://movies/sets/%s/?setid=%s", "media": "video", "properties": ["art", "title", "year", "playcount"]}, "id": 1}' % (set_id, set_id)))['result']['files']

movieItems = []
for movie in movies:
	label = '[%s] %s' % (getString(20338), movie['label'])
	if movie['year'] != 1601: label += ' (%s)' % movie['year']

	label2 = ''
	if movie['playcount'] > 0: label2 = getString(16102)

	art = ''
	if movie['art'].get('poster'): art = movie['art'].get('poster')
	elif movie['art'].get('thumb'): art = movie['art'].get('thumb')

	item = xbmcgui.ListItem(label, label2)
	item.setArt({'thumb': art})
	movieItems.append(item)

# 选择电影集影片
select = xbmcgui.Dialog().select(getString(283), movieItems, useDetails = True)
if select == -1: sys.exit()

# 打开影片信息
xbmc.executebuiltin('Dialog.Close("12003","true")')
xbmc.executebuiltin('ActivateWindow("10028","videodb://movies/sets/%s/?setid=%s")' % (set_id, set_id))
xbmc.executebuiltin('Control.SetFocus("50","%d","absolute")' % select)
xbmc.executebuiltin('Action("Info")')

window_id = xbmcgui.getCurrentWindowId()
if window_id != 10028: # 信息从主页或视频页打开
	xbmcgui.Window(10028).close()
else: # 信息从播放列表打开
	while xbmc.getCondVisibility('Window.IsActive("12003")'): xbmc.sleep(100)
	xbmc.executebuiltin('ReloadSkin()')