# -*- coding: utf-8 -*-
import xbmc, xbmcvfs
import sys, os, json

# 编码
if sys.getdefaultencoding() != 'utf-8':
	reload(sys)
	sys.setdefaultencoding('utf-8')

# 主程序
art_url = sys.argv[1]

if 'http://' in art_url or 'https://' in art_url: # 图片为网络地址
	textures = json.loads(xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "Textures.GetTextures", "params": {"properties": ["cachedurl"], "filter": {"field": "url", "operator": "is", "value": "%s"}}, "id": 1}' % art_url))

	try:
		short_url = textures['result']['textures'][0]['cachedurl']
		full_url = os.path.join(xbmcvfs.translatePath('special://profile/Thumbnails/'), short_url)
		if os.path.exists(full_url): art_url = full_url # 缓存图片不存在

	except IndexError: # 图片未缓存到本地
		pass

xbmc.executebuiltin('ShowPicture("%s")' % art_url)