# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcvfs
import os, shutil, re

# 常数
__addonname__ = 'Estuary Plus'
__addonid__   = 'skin.estuaryplus'

# 函数
def getString(stringID):
	string = xbmc.getLocalizedString(stringID)
	return string

def delDir(dirPath):
	childList = os.listdir(dirPath)
	for childItem in childList:
		childPath = os.path.join(dirPath, childItem)
		if os.path.isfile(childPath): os.remove(childPath)
		else: delDir(childPath)
	os.rmdir(dirPath)

def half2full(hString):
	fString = ''
	for hChar in hString:
		code = ord(hChar)
		if code >= 48 and code <= 57: code += 65248
		fChar = unichr(code)
		fString += fChar

	return fString

# 类
class MenuList:
	def __init__(self, menus = []):
		self.menus = menus

	def create(self, includesData):
		# 读取皮肤包含文件
		regex = re.compile('(\t\t<item>.+?</item>\n)', re.DOTALL)
		homeMenuItems = regex.findall(includesData)

		regex = re.compile('(\t\t<control type="group" id="\d+?">.+?</control>.*?</control>\n)', re.DOTALL)
		homeMenuWidgets = regex.findall(includesData)

		regex = re.compile('(\t\t<control type="radiobutton" id="\d+?">.+?</control>.*?</control>\n)', re.DOTALL)
		settingMenuItems = regex.findall(includesData)

		for i in range(len(homeMenuItems)): 
			try:
				menu = Menu(homeMenuItems[i], homeMenuWidgets[i], settingMenuItems[i])
				self.menus.append(menu)
			except IndexError:
				break

	def add(self, menu, index = 0):
		self.menus.insert(index, menu)

	def sort(self, sortIndexs):
		originMenus = self.menus[:]
		self.menus = [originMenus[i] for i in sortIndexs]

	def remove(self, index = 0):
		removeMenu = self.menus.pop(index)
		return removeMenu

	def removeall(self):
		removeMenus = self.menus
		self.menus = []
		return removeMenus

	def makeIncludes(self, profileName):
		# 创建皮肤包含文件
		includesDir = xbmcvfs.translatePath('special://skin/xml/%s' % profileName)
		if not os.path.exists(includesDir): os.makedirs(includesDir)
		includesFile = os.path.join(includesDir, 'Includes_CustomMenu.xml')
		fHandle = open(includesFile, 'w', encoding='utf-8')
		fHandle.write('<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>\n')
		fHandle.write('<includes>\n')

		# 主页菜单项
		fHandle.write('\t<include name="HomeMenuItem">\n')
		for i in range(len(self.menus)): fHandle.write(self.menus[i].homeMenuItem)
		fHandle.write('\t</include>\n')

		# 主页菜单部件
		fHandle.write('\t<include name="HomeMenuWidget">\n')
		for i in range(len(self.menus)): fHandle.write(self.menus[i].homeMenuWidget)
		fHandle.write('\t</include>\n')

		# 设定页菜单项
		fHandle.write('\t<include name="SettingMenuItem">\n')
		for i in range(len(self.menus)): fHandle.write(self.menus[i].settingMenuItem)
		fHandle.write('\t</include>\n')

		fHandle.write('</includes>')
		fHandle.close()

		backupDir = xbmcvfs.translatePath('special://profile/addon_data/%s/xml' % __addonid__)
		if not os.path.exists(backupDir): os.makedirs(backupDir)
		shutil.copy(includesFile, backupDir)

	def getMenuLabelList(self):
		menuLabelList = [self.menus[i].getMenuLabel() for i in range(len(self.menus))]
		return menuLabelList

	def getMenuIDList(self):
		menuIDList = [self.menus[i].getMenuID() for i in range(len(self.menus))]
		return menuIDList

	def getNewMenuID(self):
		menuID = 1
		sortIDList = sorted(self.getMenuIDList())
		for i in range(len(sortIDList)):
			if menuID == sortIDList[i]:
				menuID += 1
				continue
			else: break

		return menuID

class Menu:
	def __init__(self, homeMenuItem = '', homeMenuWidget = '', settingMenuItem = ''):
		self.homeMenuItem = homeMenuItem
		self.homeMenuWidget = homeMenuWidget
		self.settingMenuItem = settingMenuItem

	def create(self, menuID, menuThumb, playlistData, rollBack):
		pDialog = xbmcgui.DialogProgress()
		pDialog.create(__addonname__)

		# 创建库节点文件
		regex = re.compile('<smartplaylist type="(.+?)">.*?<name>(.+?)</name>(.+?)</smartplaylist>', re.DOTALL)
		match = regex.findall(playlistData)
		if len(match) != 0:
			menuContent = match[0][0]
			menuLabel = match[0][1]
			if str.isdigit(menuLabel): menuLabel = half2full(menuLabel)
		else:
			xbmcgui.Dialog().ok(__addonname__, getString(131075))
			return False

		reg = re.compile('(<match>.+/(?:rule)?>)', re.DOTALL)
		mat = reg.findall(match[0][2])
		if len(mat) != 0: menuRules = mat[0]
		else: menuRules = ''

		# 合并路径规则
		reg = re.compile('\n    <rule field="path" operator="contains">(\n        <value>.+?</value>)\n    </rule>', re.DOTALL)
		mat = reg.findall(menuRules)
		if len(mat)>1:
			menuRules = re.sub('\n    <rule field="path" operator="contains".*?/rule>', '', menuRules, 0, re.DOTALL)
			menuRules += '\n    <rule field="path" operator="contains">'
			menuRules += ''.join(mat)
			menuRules += '\n    </rule>'

		reg = re.compile('\n    <rule field="path" operator="is">(\n        <value>.+?</value>)\n    </rule>', re.DOTALL)
		mat = reg.findall(menuRules)
		if len(mat)>1:
			menuRules = re.sub('\n    <rule field="path" operator="is".*?/rule>', '', menuRules, 0, re.DOTALL)
			menuRules += '\n    <rule field="path" operator="is">'
			menuRules += ''.join(mat)
			menuRules += '\n    </rule>'

		if menuContent == 'movies':
			menuNodes = [('index', menuLabel, menuThumb),
                         ('recentlyaddedmovies', '20382', 'DefaultRecentlyAddedMovies.png'),
                         ('genres', '135', 'DefaultGenre.png'),
                         ('titles', '10024', 'DefaultMovieTitle.png'),
                         ('years', '652', 'DefaultYear.png'),
                         ('actors', '344', 'DefaultActor.png'),
                         ('directors', '20348', 'DefaultDirector.png'),
                         ('studios', '20388', 'DefaultStudios.png'),
                         ('sets', '20434', 'DefaultSets.png'),
                         ('countries', '20451', 'DefaultCountry.png'),
                         ('tags', '20459', 'DefaultTags.png')]
		elif menuContent == 'tvshows':
			menuNodes = [('index', menuLabel, menuThumb),
                         ('recentlyaddedepisodes', '20382', 'DefaultRecentlyAddedEpisodes.png'),
                         ('inprogressshows', '575', 'DefaultInProgressShows.png'),
                         ('genres', '135', 'DefaultGenre.png'),
                         ('titles', '10024', 'DefaultTVShowTitle.png'),
                         ('years', '652', 'DefaultYear.png'),
                         ('actors', '344', 'DefaultActor.png'),
                         ('studios', '20388', 'DefaultStudios.png'),
                         ('tags', '20459', 'DefaultTags.png')]
		else:
			xbmcgui.Dialog().ok(__addonname__, getString(131075))
			return False

		menuNodeDir = xbmcvfs.translatePath('special://profile/library/custom/menu_%d' % menuID)
		if os.path.exists(menuNodeDir): delDir(menuNodeDir)
		os.makedirs(menuNodeDir)

		for i in range(len(menuNodes)):
			menuNodeFile = os.path.join(menuNodeDir, '%s.xml' % menuNodes[i][0])
			fHandle = open(menuNodeFile, 'w', encoding='utf-8')
			fHandle.write('<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>\n')
			if menuNodes[i][0] == 'index': fHandle.write('<node order="%d">\n' % (i+1))
			else: fHandle.write('<node order="%d" type="filter">\n' % i)

			if menuNodes[i][0] == 'index':
				fHandle.write('    <label>%s</label>\n' % menuNodes[i][1])
				fHandle.write('    <icon>%s</icon>\n' % menuNodes[i][2])

			elif menuNodes[i][0] == 'titles':
				fHandle.write('    <label>%s</label>\n' % menuNodes[i][1])
				fHandle.write('    <icon>%s</icon>\n' % menuNodes[i][2])
				fHandle.write('    <content>%s</content>\n' % menuContent)
				fHandle.write('    <order direction="ascending">sorttitle</order>\n')
				if menuRules != "": fHandle.write('    %s\n' % menuRules)

			elif menuNodes[i][0] == 'recentlyaddedmovies':
				fHandle.write('    <label>%s</label>\n' % menuNodes[i][1])
				fHandle.write('    <icon>%s</icon>\n' % menuNodes[i][2])
				fHandle.write('    <content>%s</content>\n' % menuContent)
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="playcount".+?/rule>', '', menuRules, 0, re.DOTALL))
				fHandle.write('    <rule field="playcount" operator="lessthan">\n')
				fHandle.write('        <value>1</value>\n')
				fHandle.write('    </rule>\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">dateadded</order>\n')

			elif menuNodes[i][0] == 'recentlyaddedepisodes':
				fHandle.write('    <label>%s</label>\n' % menuNodes[i][1])
				fHandle.write('    <icon>%s</icon>\n' % menuNodes[i][2])
				fHandle.write('    <content>%s</content>\n' % 'episodes')
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="playcount".+?/rule>', '', re.sub('field="title"', 'field="tvshow"', menuRules, 0, re.DOTALL), 0, re.DOTALL))
				fHandle.write('    <rule field="playcount" operator="lessthan">\n')
				fHandle.write('        <value>1</value>\n')
				fHandle.write('    </rule>\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">dateadded</order>\n')

			elif menuNodes[i][0] == 'inprogressshows':
				fHandle.write('    <label>%s</label>\n' % menuNodes[i][1])
				fHandle.write('    <icon>%s</icon>\n' % menuNodes[i][2])
				fHandle.write('    <content>%s</content>\n' % menuContent)
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="inprogress".+?/(?:rule)?>', '', menuRules, 0, re.DOTALL))
				fHandle.write('    <rule field="inprogress" operator="true" />\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">lastplayed</order>\n')

			else:
				fHandle.write('    <label>%s</label>\n' % menuNodes[i][1])
				fHandle.write('    <icon>%s</icon>\n' % menuNodes[i][2])
				fHandle.write('    <content>%s</content>\n' % menuContent)
				fHandle.write('    <group>%s</group>\n' % menuNodes[i][0])
				if menuRules != "": fHandle.write('    %s\n' % menuRules)

			fHandle.write('</node>')
			fHandle.close()

			pDialog.update(100*(i+1)//len(menuNodes), getString(131080).format(menuNodes[i][0]))
			if pDialog.iscanceled():
				if rollBack:
					delDir(menuNodeDir)
				pDialog.close()
				return False

		# 创建部件播放列表
		wPlaylistDir = xbmcvfs.translatePath('special://profile/addon_data/%s/playlists/menu_%d' % (__addonid__, menuID))
		if os.path.exists(wPlaylistDir): delDir(wPlaylistDir)
		os.makedirs(wPlaylistDir)

		if menuContent == 'movies':
			wPlaylists = ['inprogress_movies', 'recent_unwatched_movies', 'unwatched_movies', 'random_movies']
		elif menuContent == 'tvshows':
			wPlaylists = ['inprogress_tvshows', 'recent_unwatched_episodes', 'unwatched_tvshows', 'random_tvshows']

		for i in range(len(wPlaylists)): 
			wPlaylistFile = os.path.join(wPlaylistDir, '%s.xsp' % wPlaylists[i])
			fHandle = open(wPlaylistFile, 'w', encoding='utf-8')
			fHandle.write('<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>\n')
			if wPlaylists[i] == 'recent_unwatched_episodes': fHandle.write('<smartplaylist type="episodes">\n')
			else: fHandle.write('<smartplaylist type="%s">\n' % menuContent)

			if wPlaylists[i] == 'inprogress_movies':
				fHandle.write('    <name>In-progress movies</name>\n')
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="inprogress".+?/(?:rule)?>', '', menuRules, 0, re.DOTALL))
				fHandle.write('    <rule field="inprogress" operator="true" />\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">lastplayed</order>\n')

			elif wPlaylists[i] == 'recent_unwatched_movies':
				fHandle.write('    <name>Recent Unwatched Movies</name>\n')
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="playcount".+?/rule>', '', menuRules, 0, re.DOTALL))
				fHandle.write('    <rule field="playcount" operator="lessthan">\n')
				fHandle.write('        <value>1</value>\n')
				fHandle.write('    </rule>\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">dateadded</order>\n')

			elif wPlaylists[i] == 'unwatched_movies':
				fHandle.write('    <name>Unwatched movies</name>\n')
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="playcount".+?/rule>', '', menuRules, 0, re.DOTALL))
				fHandle.write('    <rule field="playcount" operator="is">\n')
				fHandle.write('        <value>0</value>\n')
				fHandle.write('    </rule>\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">random</order>\n')

			elif wPlaylists[i] == 'random_movies':
				fHandle.write('    <name>Random movies</name>\n')
				if menuRules != "": fHandle.write('    %s\n' % menuRules)
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">random</order>\n')

			elif wPlaylists[i] == 'inprogress_tvshows':
				fHandle.write('    <name>In-progress tvshows</name>\n')
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="inprogress".+?/(?:rule)?>', '', menuRules, 0, re.DOTALL))
				fHandle.write('    <rule field="inprogress" operator="true" />\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">lastplayed</order>\n')

			elif wPlaylists[i] == 'recent_unwatched_episodes':
				fHandle.write('    <name>Recent Unwatched Episodes</name>\n')
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="playcount".+?/rule>', '', re.sub('field="title"', 'field="tvshow"', menuRules, 0, re.DOTALL), 0, re.DOTALL))
				fHandle.write('    <rule field="playcount" operator="lessthan">\n')
				fHandle.write('        <value>1</value>\n')
				fHandle.write('    </rule>\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">dateadded</order>\n')

			elif wPlaylists[i] == 'unwatched_tvshows':
				fHandle.write('    <name>Unwatched TV shows</name>\n')
				if menuRules != "": fHandle.write('    %s\n' % re.sub('\n    <rule field="numwatched".+?/rule>', '', re.sub('\n    <rule field="numepisodes".+?/rule>', '', menuRules, 0, re.DOTALL), 0, re.DOTALL))
				fHandle.write('    <rule field="numwatched" operator="is">\n')
				fHandle.write('        <value>0</value>\n')
				fHandle.write('    </rule>\n')
				fHandle.write('    <rule field="numepisodes" operator="greaterthan">\n')
				fHandle.write('        <value>0</value>\n')
				fHandle.write('    </rule>\n')
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="ascending">random</order>\n')

			elif wPlaylists[i] == 'random_tvshows':
				fHandle.write('    <name>Random tvshows</name>\n')
				if menuRules != "": fHandle.write('    %s\n' % menuRules)
				fHandle.write('    <limit>15</limit>\n')
				fHandle.write('    <order direction="descending">random</order>\n')

			fHandle.write('</smartplaylist>')
			fHandle.close()

			pDialog.update(100*(i+1)//len(wPlaylists), getString(131081).format(wPlaylists[i]))
			if pDialog.iscanceled():
				if rollBack:
					delDir(wPlaylistDir)
					delDir(menuNodeDir)
				pDialog.close()
				return False

		# 生成主页菜单项
		self.homeMenuItem  = '\t\t<item>\n'
		self.homeMenuItem += '\t\t\t<label>%s</label>\n' % menuLabel
		self.homeMenuItem += '\t\t\t<onclick condition="Integer.IsGreater(Container(%d).NumItems,0) + Skin.HasSetting(home_no_categories_widget)">ActivateWindow(Videos,library://custom/menu_%d,return)</onclick>\n' % ((22500+1000*(menuID-1)), menuID)
		self.homeMenuItem += '\t\t\t<onclick condition="Integer.IsGreater(Container(%d).NumItems,0) + !Skin.HasSetting(home_no_categories_widget)">ActivateWindow(Videos,library://custom/menu_%d/titles.xml,return)</onclick>\n' % ((22500+1000*(menuID-1)), menuID)
		self.homeMenuItem += '\t\t\t<onclick condition="!Integer.IsGreater(Container(%d).NumItems,0)">ActivateWindow(Videos,sources://video/,return)</onclick>\n' % (22500+1000*(menuID-1))
		self.homeMenuItem += '\t\t\t<property name="menu_id">$NUMBER[%d]</property>\n' % (22000+1000*(menuID-1))
		self.homeMenuItem += '\t\t\t<thumb>%s</thumb>\n' % menuThumb
		self.homeMenuItem += '\t\t\t<property name="id">menu_%d</property>\n' % menuID
		self.homeMenuItem += '\t\t\t<visible>!Skin.HasSetting(HomeMenuNo%dButton)</visible>\n' % menuID
		self.homeMenuItem += '\t\t</item>\n'

		# 生成主页菜单部件
		if menuContent == 'movies':
			menuWidgets = [('inprogress_movies', '31010'),
                           ('recent_unwatched_movies', '20386'),
                           ('unwatched_movies', '31007'),
                           ('random_movies', '31006')]
		elif menuContent == 'tvshows':
			menuWidgets = [('inprogress_tvshows', '626'),
                           ('recent_unwatched_episodes', '20387'),
                           ('unwatched_tvshows', '31122'),
                           ('random_tvshows', '131006')]

		self.homeMenuWidget  = '\t\t<control type="group" id="%d">\n' % (22000+1000*(menuID-1))
		self.homeMenuWidget += '\t\t\t<visible>String.IsEqual(Container(9000).ListItem.Property(id),menu_%d)</visible>\n' % menuID
		self.homeMenuWidget += '\t\t\t<include content="Visible_Right_Delayed">\n'
		self.homeMenuWidget += '\t\t\t\t<param name="id" value="menu_%d"/>\n' % menuID
		self.homeMenuWidget += '\t\t\t</include>\n'

		self.homeMenuWidget += '\t\t\t<control type="grouplist" id="%d">\n' % (22001+1000*(menuID-1))
		self.homeMenuWidget += '\t\t\t\t<include>WidgetGroupListCommon</include>\n'
		self.homeMenuWidget += '\t\t\t\t<include content="WidgetListCategories">\n'
		self.homeMenuWidget += '\t\t\t\t\t<param name="visible" value="!Integer.IsEqual(Container(%d).NumItems,0) + !Skin.HasSetting(home_no_categories_widget)"/>\n' % (22500+1000*(menuID-1))
		self.homeMenuWidget += '\t\t\t\t\t<param name="content_path" value="library://custom/menu_%d"/>\n' % menuID
		self.homeMenuWidget += '\t\t\t\t\t<param name="widget_header" value="$LOCALIZE[31148]"/>\n'
		self.homeMenuWidget += '\t\t\t\t\t<param name="widget_target" value="videos"/>\n'
		self.homeMenuWidget += '\t\t\t\t\t<param name="list_id" value="%d"/>\n' % (22100+1000*(menuID-1))
		self.homeMenuWidget += '\t\t\t\t</include>\n'

		for i in range(len(menuWidgets)):
			if menuWidgets[i][0] == 'recent_unwatched_episodes': self.homeMenuWidget += '\t\t\t\t<include content="WidgetListEpisodes">\n'
			else:
				self.homeMenuWidget += '\t\t\t\t<include content="WidgetListPoster" condition="!Skin.HasSetting(EnablePlus%d)">\n' % menuID
				self.homeMenuWidget += '\t\t\t\t\t<param name="content_path" value="special://profile/addon_data/%s/playlists/menu_%d/%s.xsp"/>\n' % (__addonid__, menuID, menuWidgets[i][0])
				self.homeMenuWidget += '\t\t\t\t\t<param name="widget_header" value="$LOCALIZE[%s]"/>\n' % menuWidgets[i][1]
				self.homeMenuWidget += '\t\t\t\t\t<param name="widget_target" value="videos"/>\n'
				self.homeMenuWidget += '\t\t\t\t\t<param name="list_id" value="%d"/>\n' % ((22200+1000*(menuID-1))+100*i)
				self.homeMenuWidget += '\t\t\t\t</include>\n'
				self.homeMenuWidget += '\t\t\t\t<include content="WidgetListPosterPlus" condition="Skin.HasSetting(EnablePlus%d)">\n' % menuID
			self.homeMenuWidget += '\t\t\t\t\t<param name="content_path" value="special://profile/addon_data/%s/playlists/menu_%d/%s.xsp"/>\n' % (__addonid__, menuID, menuWidgets[i][0])
			self.homeMenuWidget += '\t\t\t\t\t<param name="widget_header" value="$LOCALIZE[%s]"/>\n' % menuWidgets[i][1]
			self.homeMenuWidget += '\t\t\t\t\t<param name="widget_target" value="videos"/>\n'
			self.homeMenuWidget += '\t\t\t\t\t<param name="list_id" value="%d"/>\n' % ((22200+1000*(menuID-1))+100*i)
			self.homeMenuWidget += '\t\t\t\t</include>\n'

		self.homeMenuWidget += '\t\t\t\t<include content="WidgetListCategories">\n'
		self.homeMenuWidget += '\t\t\t\t\t<param name="content_path" value="library://custom/menu_%d/genres.xml"/>\n' % menuID
		self.homeMenuWidget += '\t\t\t\t\t<param name="widget_header" value="$LOCALIZE[135]"/>\n'
		self.homeMenuWidget += '\t\t\t\t\t<param name="widget_target" value="videos"/>\n'
		self.homeMenuWidget += '\t\t\t\t\t<param name="list_id" value="%d"/>\n' % (22900+1000*(menuID-1))
		self.homeMenuWidget += '\t\t\t\t\t<param name="icon" value="$VAR[WidgetGenreIconVar]"/>\n'
		self.homeMenuWidget += '\t\t\t\t\t<param name="icon_height" value="70"/>\n'
		self.homeMenuWidget += '\t\t\t\t</include>\n'
		self.homeMenuWidget += '\t\t\t</control>\n'

		self.homeMenuWidget += '\t\t\t<include content="ImageWidget">\n'
		self.homeMenuWidget += '\t\t\t\t<param name="visible" value="Integer.IsEqual(Container(%d).NumItems,0)"/>\n' % (22500+1000*(menuID-1))
		self.homeMenuWidget += '\t\t\t\t<param name="text_label" value="$LOCALIZE[31104]" />\n'
		self.homeMenuWidget += '\t\t\t\t<param name="button_label" value="$LOCALIZE[31110]" />\n'
		self.homeMenuWidget += '\t\t\t\t<param name="button_onclick" value="ActivateWindow(videos,files,return)"/>\n'
		self.homeMenuWidget += '\t\t\t\t<param name="button_id" value="%d"/>\n' % (22900+1000*(menuID-1))
		self.homeMenuWidget += '\t\t\t\t<param name="button2_onclick" value="Skin.SetBool(HomeMenuNo%dButton)"/>\n' % menuID
		self.homeMenuWidget += '\t\t\t</include>\n'
		self.homeMenuWidget += '\t\t</control>\n'

		# 生成设定页菜单项
		self.settingMenuItem  = '\t\t<control type="radiobutton" id="%d">\n' % (621+menuID)
		self.settingMenuItem += '\t\t\t<label>%s</label>\n' % menuLabel
		self.settingMenuItem += '\t\t\t<include>DefaultSettingButton</include>\n'
		self.settingMenuItem += '\t\t\t<selected>!Skin.HasSetting(HomeMenuNo%dButton)</selected>\n' % menuID
		self.settingMenuItem += '\t\t\t<onclick>Skin.ToggleSetting(HomeMenuNo%dButton)</onclick>\n' % menuID
		self.settingMenuItem += '\t\t</control>\n'

		self.settingMenuItem += '\t\t<control type="radiobutton" id="%d">\n' % (7621+menuID)
		self.settingMenuItem += '\t\t\t<label>- $LOCALIZE[131096]</label>\n'
		self.settingMenuItem += '\t\t\t<include>DefaultSettingButton</include>\n'
		self.settingMenuItem += '\t\t\t<selected>Skin.HasSetting(EnablePlus%d)</selected>\n' % menuID
		self.settingMenuItem += '\t\t\t<onclick>Skin.ToggleSetting(EnablePlus%d)</onclick>\n' % menuID
		self.settingMenuItem += '\t\t\t<enable>!Skin.HasSetting(HomeMenuNo%dButton)</enable>\n' % menuID
		self.settingMenuItem += '\t\t</control>\n'

		pDialog.close()
		return True

	def destroy(self):
		# 获取菜单ID
		menuID = self.getMenuID()

		# 删除部件播放列表
		wPlaylistDir = xbmcvfs.translatePath('special://profile/addon_data/%s/playlists/menu_%d' % (__addonid__, menuID))
		if os.path.exists(wPlaylistDir): delDir(wPlaylistDir)

		# 删除库节点文件
		menuNodeDir = xbmcvfs.translatePath('special://profile/library/custom/menu_%d' % menuID)
		if os.path.exists(menuNodeDir): delDir(menuNodeDir)

		# 释放自己
		del self

		return menuID

	def getMenuLabel(self):
		menuLabel = ''
		regex = re.compile('<label>(.+?)</label>', re.DOTALL)
		match = regex.findall(self.settingMenuItem)
		if len(match) != 0:
			menuLabel = match[0]

		return menuLabel

	def getMenuID(self):
		menuID = 0
		regex = re.compile('<property name="id">menu_(\d+?)</property>', re.DOTALL)
		match = regex.findall(self.homeMenuItem)
		if len(match) != 0:
			menuID = int(match[0])

		return menuID

	def getMenuThumb(self):
		menuThumb = ''
		regex = re.compile('<thumb>(.+?)</thumb>', re.DOTALL)
		match = regex.findall(self.homeMenuItem)
		if len(match) != 0:
			menuThumb = match[0]

		return menuThumb