# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcvfs
import sys, os, urllib.parse
from module.plus import __addonname__, getString, MenuList, Menu

# 编码
if sys.getdefaultencoding() != 'utf-8':
	reload(sys)
	sys.setdefaultencoding('utf-8')

# 函数
def createPlaylist(playlistFile):
	fileDir, fileName = os.path.split(playlistFile)
	if not os.path.exists(fileDir): os.makedirs(fileDir)
	fHandle = open(playlistFile, 'w', encoding='utf-8')
	fHandle.write('<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>\n')
	fHandle.write('<smartplaylist type="movies">\n')
	fHandle.write('    <name>%s%s</name>\n' % (getString(131071), fileName[fileName.find('_'):fileName.find('.')]))
	fHandle.write('    <match>all</match>\n')
	fHandle.write('</smartplaylist>')
	fHandle.close()

def activatePlaylistEditor(playlistFile, heading):
	xbmcgui.Window(10136).clearProperty('onclick')
	xbmcgui.Window(10136).setProperty('Heading', heading)
	xbmcgui.Window(10137).setProperty('Heading', getString(131044))
	xbmc.executebuiltin('ActivateWindow("smartplaylisteditor","%s")' % playlistFile)
	while not xbmc.getCondVisibility('Window.IsActive("smartplaylisteditor")'): xbmc.sleep(100)
	while xbmc.getCondVisibility('Window.IsActive("smartplaylisteditor")'): xbmc.sleep(100)
	onclick = xbmcgui.Window(10136).getProperty('onclick')
	return onclick

def selectThumb(thumbDir, defaultIcon):
	thumbIcons = [icon for icon in os.listdir(thumbDir) if os.path.isfile(os.path.join(thumbDir, icon))]
	thumbItems = []
	for icon in thumbIcons:
		item = xbmcgui.ListItem(icon)
		item.setArt({'thumb': os.path.join(thumbDir, icon)})
		thumbItems.append(item)

	menuThumb = os.path.join(thumbDir, defaultIcon)
	if len(thumbItems) != 0:
		try:
			defaultIndex = thumbIcons.index(defaultIcon)
		except Exception:
			defaultIndex = 0
			pass

		select = xbmcgui.Dialog().select(getString(131072), thumbItems, preselect = defaultIndex, useDetails = True)
		if select == -1: return None
		menuThumb = thumbItems[select].getArt('thumb')

	return menuThumb

def addMenu():
	# 获取要新增的菜单
	menuList = MenuList()
	includesFile = xbmcvfs.translatePath('special://skin/xml/%s/Includes_CustomMenu.xml' % profileName)
	if os.path.exists(includesFile): 
		fHandle = open(includesFile, 'r', encoding='utf-8')
		includesData = fHandle.read()
		fHandle.close()
		menuList.create(includesData)

	menuID = menuList.getNewMenuID()

	# 创建空白智能播放列表
	playlistFile = xbmcvfs.translatePath('special://profile/playlists/custom/menu_%d.xsp' % menuID)
	createPlaylist(playlistFile)

	# 获取列表修改时间
	mTime = os.path.getmtime(playlistFile)

	while True:
		# 打开列表编辑窗口
		onclick = activatePlaylistEditor(playlistFile, getString(131063))
		if onclick != 'confirm': # 取消新增菜单
			os.remove(playlistFile)
			return

		# 选择图标
		menuThumb = selectThumb(xbmcvfs.translatePath('special://skin/media/iconsplus'), 'videos.png')
		if menuThumb != None: break

	# 确认新增菜单
	while not os.path.exists(playlistFile) or (os.path.exists(playlistFile) and os.path.getmtime(playlistFile) == mTime): xbmc.sleep(100)
	fHandle = open(playlistFile, 'r', encoding='utf-8')
	playlistData = fHandle.read()
	fHandle.close()

	menu = Menu() # 创建菜单
	isCreate = menu.create(menuID, menuThumb, playlistData, True)
	if not isCreate: # 创建不成功
		os.remove(playlistFile)
		return

	menuList.add(menu)
	menuList.makeIncludes(profileName)

	xbmc.executebuiltin('Skin.Reset(HomeMenuNo%dButton)' % menuID)
	xbmc.executebuiltin('Skin.Reset(EnablePlus%d)' % menuID)
	xbmc.executebuiltin('ReloadSkin()')

def editMenu():
	# 获取要编辑的菜单
	menuList = MenuList()
	includesFile = xbmcvfs.translatePath('special://skin/xml/%s/Includes_CustomMenu.xml' % profileName)
	if os.path.exists(includesFile): 
		fHandle = open(includesFile, 'r', encoding='utf-8')
		includesData = fHandle.read()
		fHandle.close()
		menuList.create(includesData)

	if len(menuList.menus) == 0:
		xbmcgui.Dialog().ok(__addonname__, getString(131073))
		return

	menuLabelList = menuList.getMenuLabelList()
	select = xbmcgui.Dialog().select(getString(131074), menuLabelList)
	if select == -1: return # 取消选择

	menuID = menuList.menus[select].getMenuID()

	# 读取智能播放列表
	playlistFile = xbmcvfs.translatePath('special://profile/playlists/custom/menu_%d.xsp' % menuID)
	if not os.path.exists(playlistFile): createPlaylist(playlistFile)

	# 获取列表修改时间
	mTime = os.path.getmtime(playlistFile)

	while True:
		# 打开列表编辑窗口
		onclick = activatePlaylistEditor(playlistFile, getString(131064))
		if onclick != 'confirm': return # 取消编辑菜单

		# 选择图标
		menuThumb = menuList.menus[select].getMenuThumb()
		menuThumb = selectThumb(xbmcvfs.translatePath('special://skin/media/iconsplus'), os.path.basename(menuThumb))
		if menuThumb != None: break

	# 确认编辑菜单
	while not os.path.exists(playlistFile) or (os.path.exists(playlistFile) and os.path.getmtime(playlistFile) == mTime): xbmc.sleep(100)
	fHandle = open(playlistFile, 'r', encoding='utf-8')
	playlistData = fHandle.read()
	fHandle.close()

	menu = Menu() # 创建菜单
	isCreate = menu.create(menuID, menuThumb, playlistData, False)
	if not isCreate: return # 创建不成功

	menuList.remove(select)
	menuList.add(menu, select)
	menuList.makeIncludes(profileName)

	xbmc.executebuiltin('ReloadSkin()')

def sortMenu():
	# 获取要排序的菜单ID
	menuList = MenuList()
	includesFile = xbmcvfs.translatePath('special://skin/xml/%s/Includes_CustomMenu.xml' % profileName)
	if os.path.exists(includesFile): 
		fHandle = open(includesFile, 'r', encoding='utf-8')
		includesData = fHandle.read()
		fHandle.close()
		menuList.create(includesData)

	if len(menuList.menus) == 0:
		xbmcgui.Dialog().ok(__addonname__, getString(131073))
		return

	menuIDList = menuList.getMenuIDList()
	menuLabelList = menuList.getMenuLabelList()

	# 生成新顺序的菜单序号
	i = 1
	sortIndexs = []
	originIDlist = menuIDList[:]
	while len(menuLabelList) > 0:
		select = xbmcgui.Dialog().select(getString(131076).format(i), menuLabelList)
		if select == -1: return # 取消选择

		menuLabelList.pop(select)
		sortIndexs.insert(0, originIDlist.index(menuIDList.pop(select)))
		i += 1

	menuList.sort(sortIndexs)
	menuList.makeIncludes(profileName)

	xbmc.executebuiltin('ReloadSkin()')

def removeMenu():
	# 获取要删除的菜单
	menuList = MenuList()
	includesFile = xbmcvfs.translatePath('special://skin/xml/%s/Includes_CustomMenu.xml' % profileName)
	if os.path.exists(includesFile): 
		fHandle = open(includesFile, 'r', encoding='utf-8')
		includesData = fHandle.read()
		fHandle.close()
		menuList.create(includesData)

	if len(menuList.menus) == 0:
		xbmcgui.Dialog().ok(__addonname__, getString(131073))
		return

	menuLabelList = menuList.getMenuLabelList()
	select = xbmcgui.Dialog().select(getString(131077), menuLabelList)
	if select == -1: return # 取消选择

	menuLabel = menuLabelList[select]
	isRemove = xbmcgui.Dialog().yesno(__addonname__, getString(131078).format(menuLabel))
	if not isRemove: return # 取消删除

	# 删除包含文件
	removeMenu = menuList.remove(select)
	menuList.makeIncludes(profileName)

	# 删除节点文件和播放列表
	menuID = removeMenu.destroy()
	playlistFile = xbmcvfs.translatePath('special://profile/playlists/custom/menu_%d.xsp' % menuID)
	if os.path.exists(playlistFile): os.remove(playlistFile)

	xbmc.executebuiltin('ReloadSkin()')

def removeAllMenu():
	menuList = MenuList()
	includesFile = xbmcvfs.translatePath('special://skin/xml/%s/Includes_CustomMenu.xml' % profileName)
	if os.path.exists(includesFile): 
		fHandle = open(includesFile, 'r', encoding='utf-8')
		includesData = fHandle.read()
		fHandle.close()
		menuList.create(includesData)

	if len(menuList.menus) == 0:
		xbmcgui.Dialog().ok(__addonname__, getString(131073))
		return

	isRemove = xbmcgui.Dialog().yesno(__addonname__, getString(131079))
	if not isRemove: return # 取消删除

	# 删除包含文件
	removeMenus = menuList.removeall()
	menuList.makeIncludes(profileName)

	# 删除节点文件和播放列表
	menuIDs = []
	for i in range(len(removeMenus)):
		menuID = removeMenus[i].destroy()
		menuIDs.append(menuID)

	for i in range(len(menuIDs)):
		playlistFile = xbmcvfs.translatePath('special://profile/playlists/custom/menu_%d.xsp' % menuIDs[i])
		if os.path.exists(playlistFile): os.remove(playlistFile)

	xbmc.executebuiltin('ReloadSkin()')

# 主程序
params = dict(urllib.parse.parse_qsl(urllib.parse.unquote_plus(sys.argv[1])))
mode = params.get('mode')

# 获取登录用户名字
profileName = xbmc.getInfoLabel('System.ProfileName')

# 新增菜单
if mode == 'add':
	addMenu()

# 编辑菜单
if mode == 'edit':
	editMenu()

# 排列菜单
if mode == 'sort':
	sortMenu()

# 删除菜单
if mode == 'remove':
	removeMenu()

# 删除全部菜单
if mode == 'removeall':
	removeAllMenu()