# -*- coding: utf-8 -*-
import xbmc, xbmcvfs
import sys, os, shutil, re
from module.plus import __addonid__

# 编码
if sys.getdefaultencoding() != 'utf-8':
	reload(sys)
	sys.setdefaultencoding('utf-8')

# 主程序
skinDir = xbmc.getSkinDir()
if skinDir != __addonid__: sys.exit()

# 获取登录用户名字
profileName = xbmc.getInfoLabel('System.ProfileName')
needReloadSkin = False

# 检查Includes_CustomFiles.xml
includesDir = xbmcvfs.translatePath('special://skin/xml')
includesFile = os.path.join(includesDir, 'Includes_CustomFiles.xml')

needCreateIncludes = False
if not os.path.exists(includesFile): needCreateIncludes = True # 文件不存在则重建
else:
	fHandle = open(includesFile, 'r', encoding='utf-8')
	includesData = fHandle.read()
	fHandle.close()
	if '</includes>' not in includesData: needCreateIncludes = True # 文件不完整则重建
	else:
		regex = re.compile('(<include file="%s/Includes_CustomMenu.xml" />)' % profileName, re.DOTALL)
		match = regex.findall(includesData)
		if len(match) == 0: needCreateIncludes = True # 文件非登录用户则重建

# 重建Includes_CustomFiles.xml
if needCreateIncludes:
	fHandle = open(includesFile, "w", encoding='utf-8')
	fHandle.write('<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>\n')
	fHandle.write('<includes>\n')
	fHandle.write('\t<include file="%s/Includes_CustomMenu.xml" />\n' % profileName)
	fHandle.write('</includes>')
	fHandle.close()

	needReloadSkin = True

# 检查Includes_CustomMenu.xml
includesDir = xbmcvfs.translatePath('special://skin/xml/%s' % profileName)
includesFile = os.path.join(includesDir, 'Includes_CustomMenu.xml')

needCreateIncludes = False
if not os.path.exists(includesFile): needCreateIncludes = True # 文件不存在则重建
else:
	fHandle = open(includesFile, 'r', encoding='utf-8')
	includesData = fHandle.read()
	fHandle.close()
	if '</includes>' not in includesData: needCreateIncludes = True # 文件不完整则重建

# 重建Includes_CustomFiles.xml
if needCreateIncludes:
	if not os.path.exists(includesDir): os.makedirs(includesDir)

	backupFile = xbmcvfs.translatePath('special://profile/addon_data/%s/xml/Includes_CustomMenu.xml' % __addonid__)
	if os.path.exists(backupFile): shutil.copy(backupFile, includesDir)
	else:
		fHandle = open(includesFile, 'w', encoding='utf-8')
		fHandle.write('<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>\n')
		fHandle.write('<includes>\n')

		# 主页菜单项
		fHandle.write('\t<include name="HomeMenuItem">\n')
		fHandle.write('\t</include>\n')

		# 主页菜单部件
		fHandle.write('\t<include name="HomeMenuWidget">\n')
		fHandle.write('\t</include>\n')

		# 设定页菜单项
		fHandle.write('\t<include name="SettingMenuItem">\n')
		fHandle.write('\t</include>\n')

		fHandle.write('</includes>')
		fHandle.close()

	needReloadSkin = True

if needReloadSkin: xbmc.executebuiltin('ReloadSkin()')