﻿# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcvfs, xbmcaddon
import sys, os, shutil

# 编码
if sys.getdefaultencoding() != 'utf-8':
	reload(sys)
	sys.setdefaultencoding('utf-8')

# 常数
__addonname__ = 'Reboot to eMMC/NAND for estuary'
__addonid__   = 'script.estuary.reboot-to-emmc'
__skinid__    = 'skin.estuaryplus'

# 函数
def main():
	if not xbmc.getCondVisibility('System.Platform.Linux') or xbmc.getCondVisibility('System.Platform.Android'):
		xbmcgui.Dialog().ok(__addonname__, '本插件只适用于Linux平台，按确定退出')
		return

	if xbmc.getSkinDir() != __skinid__:
		xbmcgui.Dialog().ok(__addonname__, '本插件只适用于Estuary Plus皮肤，按确定退出')
		return

	__skin__ = xbmcaddon.Addon(id=__skinid__)
	skinDir = xbmcvfs.translatePath(__skin__.getAddonInfo('path'))

	__addon__ = xbmcaddon.Addon(id=__addonid__)
	addonDir = xbmcvfs.translatePath(__addon__.getAddonInfo('path'))

	select = xbmcgui.Dialog().select(__addonname__, ['添加 "Reboot to eMMC/NAND" 按钮到关机菜单', '从关机菜单删除 "Reboot to eMMC/NAND" 按钮'])
	if select == -1: return
	elif select == 0: source = os.path.join(addonDir, 'xml', 'DialogButtonMenu.xml')
	elif select == 1: source = os.path.join(addonDir, 'xml', 'restore', 'DialogButtonMenu.xml')

	target = os.path.join(skinDir, 'xml', 'DialogButtonMenu.xml')
	shutil.copyfile(source, target)
	xbmcgui.Dialog().ok(__addonname__, '添加/删除 "Reboot to eMMC/NAND" 按钮成功，按确定刷新')

	xbmc.executebuiltin('ReloadSkin()')

# 主程序
if __name__ == '__main__':
    main()
