# -*- coding: utf-8 -*-
import re

# 类
class m3ujson:
	@staticmethod
	def load(m3uData):
		channels = []

		regex = re.compile('(#EXTINF:.*),(.*?)\n(.*?)$', re.MULTILINE)
		match = regex.findall(m3uData)
		for entry in match:
			chn_name = entry[1].strip()
			chn_url = entry[2].strip()

			reg = re.compile('group-title="(.*?)"', re.DOTALL)
			mat = reg.findall(entry[0])
			if mat: group_title = mat[0].strip()
			else: group_title = ''

			reg = re.compile('tvg-logo="(.*?)"', re.DOTALL)
			mat = reg.findall(entry[0])
			if mat: tvg_logo = mat[0].strip()
			else: tvg_logo = ''

			channels.append({'group_title': group_title, 'tvg_logo': tvg_logo, 'chn_name': chn_name, 'chn_url': chn_url})

		return channels

	@staticmethod
	def dump(channels):
		return