# -*- coding: utf-8 -*-
import xbmcgui, xbmcvfs, xbmcplugin, xbmcaddon
import sys, os, json, base64, urllib, urllib.request, urllib.parse
from lib.utils import m3ujson

# 常数
__addonname__ = 'GitTV网络电视'
__addonid__   = 'plugin.video.gittv'

# 函数
def getAddonDir():
	addon = xbmcaddon.Addon(id=__addonid__)
	addon_dir = xbmcvfs.translatePath(addon.getAddonInfo('path'))
	return addon_dir

def getImagePath(image_name):
	addon_dir = getAddonDir()
	image_path = os.path.join(addon_dir, 'media', image_name)
	return image_path

def getHttpData(url):
	request = urllib.request.Request(url)
	request.add_header('User-Agent', 'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)')

	maxtimes = 10
	for t in range(maxtimes):
		try:
			response = urllib.request.urlopen(request)
			httpData = response.read()
			break
		except Exception as e:
			if '11004' in str(e):
				if t<maxtimes-1: continue
				else: xbmcgui.Dialog().ok(__addonname__, '网络错误 %s %s %d次' % (url, str(e), maxtimes))
			else: xbmcgui.Dialog().ok(__addonname__, '网络错误 %s %s' % (url, str(e)))
			return

	if response.headers.get('content-encoding', None) == 'gzip':
		import zlib
		httpData = zlib.decompress(httpData, zlib.MAX_WBITS|32)

	response.close()
	return httpData

def checkUrl(url):
	request = urllib.request.Request(url)
	request.add_header('User-Agent', 'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)')

	try:
		response = urllib.request.urlopen(request, timeout=5)
		code = response.getcode()
		if code != 200:
			xbmcgui.Dialog().ok(__addonname__, '连接失败 %s [%d]' % (url, code))
			return
	except Exception as e:
		xbmcgui.Dialog().ok(__addonname__, '网络错误 %s %s' % (url, str(e)))
		return

	response.close()
	return True

def createUrl(urlInfo):
	url = '%s?' % addon_url
	for key, value in urlInfo.items():
		url += '%s=%s&' % (key, urllib.parse.quote(value))
	url = url[:-1]
	return url

def showRoot():
	# 显示根目录
	items = [('Git库', 'repo'), ('收藏', 'favorite'), ('历史', 'history')]
	poster = getImagePath('default.png')
	for entry in items:
		item = xbmcgui.ListItem(entry[0])
		item.setArt({'poster': poster})
		item_url = createUrl({'mode': entry[1]})
		xbmcplugin.addDirectoryItem(pHandle, item_url, item, True)

	# 设置内容
	xbmcplugin.setContent(pHandle, 'files')
	xbmcplugin.endOfDirectory(pHandle)

def showRepo():
	# 显示Git库
	repos = [
		{'login': 'timothyisok', 'name': 'gittv', 'path': ''},
		{'login': 'imDazui', 'name': 'Tvlist-awesome-m3u-m3u8', 'path': 'm3u'},
		{'login': 'iptv-org', 'name': 'iptv', 'path': 'streams'},
		#{'login': 'YanG-1989', 'name': 'm3u', 'path': ''}
	]

	poster = getImagePath('default.png')
	for entry in repos:
		label = '%s/%s/%s' % (entry['login'], entry['name'], entry['path'])
		repo_url = 'https://api.github.com/repos/%s/%s/contents/%s' % (entry['login'], entry['name'], entry['path'])

		item = xbmcgui.ListItem(label)
		item.setArt({'poster': poster})
		item_url = createUrl({'mode': 'list', 'url': repo_url})
		xbmcplugin.addDirectoryItem(pHandle, item_url, item, True)

	# 设置内容
	xbmcplugin.setContent(pHandle, 'files')
	xbmcplugin.setPluginCategory(pHandle, 'Git库')
	xbmcplugin.endOfDirectory(pHandle)

def showList():
	url = params.get('url')
	httpData = getHttpData(url)
	if not httpData: return

	# 显示M3U列表
	m3uList = json.loads(httpData)
	poster = getImagePath('default.png')
	for entry in m3uList:
		if not entry['name'].endswith('.m3u') and not entry['name'].endswith('.m3u8'): continue

		label = entry['name']
		m3u_url = entry['url']

		item = xbmcgui.ListItem(label)
		item.setArt({'poster': poster})
		item_url = createUrl({'mode': 'channel', 'url': m3u_url})
		xbmcplugin.addDirectoryItem(pHandle, item_url, item, True)

	# 设置内容
	xbmcplugin.setContent(pHandle, 'files')
	xbmcplugin.setPluginCategory(pHandle, 'M3U列表')
	xbmcplugin.endOfDirectory(pHandle)

def showChannel():
	url = params.get('url')
	httpData = getHttpData(url)
	if not httpData: return

	# 显示频道
	m3uInfo = json.loads(httpData)
	m3uData = base64.b64decode(m3uInfo['content']).decode('utf-8')
	channels = m3ujson.load(m3uData)
	for entry in channels:
		label = entry['chn_name']
		poster = entry['tvg_logo']
		if not poster: poster = 'https://'

		video_url = entry['chn_url']
		hostname = urllib.parse.urlparse(video_url).netloc

		item = xbmcgui.ListItem('%s [%s]' % (label, hostname))
		item.setArt({'poster': poster})
		item.setInfo('video', {})
		item.setProperty('IsPlayable', 'true')
		item_url = createUrl({'mode': 'play', 'label': label, 'poster': poster, 'url': video_url})
		xbmcplugin.addDirectoryItem(pHandle, item_url, item, False)

	# 设置内容
	xbmcplugin.setContent(pHandle, 'videos')
	xbmcplugin.setPluginCategory(pHandle, '频道')
	xbmcplugin.endOfDirectory(pHandle)

def showFavorite():
	xbmcgui.Dialog().ok(__addonname__, '开发中………')
	return

def showHistory():
	xbmcgui.Dialog().ok(__addonname__, '开发中………')
	return

def playVideo():
	label = params.get('label')
	poster = params.get('poster')
	url = params.get('url')

	pDialog = xbmcgui.DialogProgress()
	pDialog.create(__addonname__)

	# 检测视频
	pDialog.update(50, '正在检测信号源 [%s] ，请稍等' % label)
	if url.startswith('http'):
		if not checkUrl(url): return

	pDialog.update(100, '信号源 [%s] 检测通过，准备播放' % label)
	pDialog.close()

	# 播放视频
	'''item = xbmcgui.ListItem(label)
	item.setArt({'poster': poster})
	item.setInfo('video', {'plot': url})
	xbmc.Player().play(url, item)'''
	item = xbmcgui.ListItem(label, path=url)
	item.setArt({'poster': poster})
	item.setInfo('video', {'plot': url})
	xbmcplugin.setResolvedUrl(pHandle, True, item)


# 主程序
addon_url = sys.argv[0]
pHandle = int(sys.argv[1])
params = dict(urllib.parse.parse_qsl(sys.argv[2][1:]))
mode = params.get('mode')

# 根目录
if mode == None:
	showRoot()

# Git库
elif mode == 'repo':
	showRepo()

# M3U列表
elif mode == 'list':
	showList()

# 频道
elif mode == 'channel':
	showChannel()

# 收藏
elif mode == 'favorite':
	showFavorite()

# 历史
elif mode == 'history':
	showHistory()

# 播放
elif mode == 'play':
	playVideo()