# -*- coding: utf-8 -*-
import xbmcgui, xbmcplugin
import sys, json, time, urllib.request, urllib.parse

# 函数
def getHttpData(url):
	request = urllib.request.Request(url)
	request.add_header('User-Agent', 'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)')

	response = urllib.request.urlopen(request)
	httpData = response.read()

	response.close()
	return httpData

def getActors(movieId):
	actor_url = 'http://front-gateway.mtime.com/library/movie/credits.api?movieId=%d' % movieId
	httpData = getHttpData(actor_url)
	jsonData = json.loads(httpData)

	actors = jsonData['data']['actors']
	if actors == None: actors = []

	settings = json.loads(params['pathSettings'])
	actors_num = settings['actors_num']
	if actors_num == '无限制' or int(actors_num) > len(actors): i = len(actors)
	else: i = int(actors_num)

	return [{'name': setValue(entry['name'], entry['nameEn']), 'role': setValue(entry['personate'], entry['personateEn']), 'thumbnail': entry['image']} for entry in actors[:i]]

def getArtworks(movieId):
	art_url = 'http://front-gateway.mtime.com/library/movie/imageAll.api?movieId=%d' % movieId
	httpData = getHttpData(art_url)
	jsonData = json.loads(httpData)

	actworks = jsonData['data']['images']
	posters = [{'image': entry['imageOrigin'], 'preview': entry['image']} for entry in actworks if entry['imageTypeUrlName'] == 'posters']
	fanarts = [{'image': entry['imageOrigin'], 'preview': entry['image']} for entry in actworks if entry['imageTypeUrlName'] == 'stills']

	return {'posters': posters, 'fanarts': fanarts}

def parseRuntime(mins):
	if mins: return 60 * int(mins[:-2])
	else: return None

def parsePremiered(releaseDate):
	if releaseDate: return time.strftime('%Y-%m-%d', time.strptime(releaseDate, '%Y%m%d'))
	else: return None

def parseEpisode(episodeCnt):
	if episodeCnt: return int(episodeCnt[:-1])
	else: return None

def parseInfo(infos):
	if infos: return [setValue(entry['name'], entry['nameEn']) for entry in infos]
	else: return None

def parseTrailer(video):
	if video: return video['hightUrl']
	else: return None

def setValue(str1, str2):
	if str1: return str1
	else: return str2

# 主程序
pHandle = int(sys.argv[1])
params = dict(urllib.parse.parse_qsl(sys.argv[2][1:]))
action = params['action']

# 从网站获取电视剧列表
if action == 'find':
	title = params['title'].strip()
	year = params.get('year')
	if year == None: year = ''
	find_url = 'http://front-gateway.mtime.com/mtime-search/search/unionSearch2?keyword=%s&year=%s' % (urllib.parse.quote(title), year)
	httpData = getHttpData(find_url)
	jsonData = json.loads(httpData)

	movies = jsonData['data']['movies']
	if movies:
		for movie in movies:
			if movie['movieContentType'] == '电视剧':
				movieId = movie['movieId']
				title = '%s (%s)' % (movie['name'], movie['year'])
				poster = movie['img']

				item = xbmcgui.ListItem()
				item.setLabel(title)
				item.addAvailableArtwork(poster, 'poster')

				item_url = 'http://front-gateway.mtime.com/library/movie/detail.api?movieId=%d' % movieId
				xbmcplugin.addDirectoryItem(pHandle, item_url, item, True)

# 从网站获取电视剧资料
elif action == 'getdetails':
	detail_url = params['url']
	httpData = getHttpData(detail_url)
	jsonData = json.loads(httpData)

	movie = jsonData['data']['basic']
	infoLabels = {
		'title': movie['name'], # The title for the TV Show
#		'originaltitle': '', # Displays the original title of the TV Show
#		'tvshowtitle': '', # Not in common use, but some skins may display an alternate title
#		'sorttitle': '', # Allows alternate title sort without modifying TV Show title
		'rating': movie['overallRating'], # rating
		'votes': movie['ratingCount'], # votes
#		'userrating': 0, # Personal rating set by the user
#		'top250': 0, # Ranking in IMDB Top 250 movies
		'season': 1, # Number of seasons of this TV Show in the library
		'episode': parseEpisode(movie['episodeCnt']), # Number of episodes of this TV Show in the library
		'plotoutline': movie['summary'], # Should be short, will be displayed on a single line
		'plot': movie['story'], # Can contain more information on multiple lines, will be wrapped
#		'tagline': '', # Short TV Show slogan
		'duration': parseRuntime(movie['mins']), # If ommitted, Kodi will add runtime upon scanning
#		'mpaa': '', # Country specific mpaa rating system
#		'playcount': 0, # Number of times TV Show has been played
#		'lastplayed': '', # Date last played as yyyy-mm-dd
		'episodeguide': json.dumps(movie, ensure_ascii=False), # When a URL is used, the corresponding scraper must be set
		'genre': movie['type'],
#		'tag': [], # Library Tags
		'country': parseInfo(movie['countries']), # Country of origin
		'credits': parseInfo(movie['writers']), # Field for credits
		'writer': parseInfo(movie['writers']), # Field for writers
		'director': parseInfo(movie['directors']), # TV Show Director
#		'cast': [], # TV Show Cast
		'premiered': parsePremiered(movie['releaseDate']), # Release date of movie. Format as yyyy-mm-dd
		'year': movie['year'], # Release Year
#		'status': '', # Continuing or Ended show
		'aired': time.strftime('%Y-%m-%d', time.strptime(movie['releaseDate'], '%Y%m%d')), # Not used
		'studio': parseInfo(movie['companies']), # Production studio
		'trailer': parseTrailer(movie['video']), # Local or online path to TV Show trailer
#		'showlink': '', # Connect TV Show to TV Show. Use the TV Show <title></title> name\
#		'dateadded': '', # mTime of the playable video file
		'mediatype': 'tvshow'}

	movieId = movie['movieId']
	poster = movie['bigImage']
	artworks = getArtworks(movieId)
	actors = getActors(movieId)

	item = xbmcgui.ListItem()
	item.setInfo('video', infoLabels) # tvshow
	item.setUniqueIDs({'mTime': movieId}, 'mTime') # The ID from the scraper site
	item.addAvailableArtwork(poster, 'poster') # Path to available TV Show Posters
	for entry in artworks['posters']: item.addAvailableArtwork(entry['image'], 'poster', entry['preview']) # Path to available TV Show Posters
	item.setAvailableFanart(artworks['fanarts']) # Path to available TV Show fanart
	item.setCast(actors) # actor

	xbmcplugin.setResolvedUrl(pHandle, True, item)

# 从网站获取电视剧分集列表
elif action == 'getepisodelist':
	movie = json.loads(params['url'])
	infoLabels = {}
	for i in range(2000):
		infoLabels['title'] = '%s 第%d集' % (movie['name'], i)
		infoLabels['season'] = 1
		infoLabels['episode'] = i		

		item = xbmcgui.ListItem()
		item.setInfo('video', infoLabels)

		item_url = json.dumps(infoLabels, ensure_ascii=False)
		xbmcplugin.addDirectoryItem(pHandle, item_url, item, True)

# 从网站获取电视剧分集资料
elif action == 'getepisodedetails':
	infoLabels = json.loads(params['url'])

	item = xbmcgui.ListItem()
	item.setInfo('video', infoLabels)

	xbmcplugin.setResolvedUrl(pHandle, True, item)

# 从本地获取电视剧信息
elif action == 'nfourl':
	pass

xbmcplugin.endOfDirectory(pHandle)