# -*- coding: utf-8 -*-
import xbmcgui, xbmcplugin
import sys, os, json, urllib.parse

# 函数
def getArtworks(artDir, title, type):
	if artDir:
		for root, dirs, files in os.walk(artDir):
			for entry in files:
				if os.path.splitext(entry)[0] == '%s-%s' % (title, type) and os.path.splitext(entry)[1] in ['.jpg', '.png', '.bmp', '.gif']:
					return os.path.join(root, entry)

def getActors(actorList):
	if len(actorList) == 1 and actorList[0] == '': return []
	else: return [{'name': entry, 'role': '', 'thumbnail': ''} for entry in actorList]

# 主程序
pHandle = int(sys.argv[1])
params = dict(urllib.parse.parse_qsl(sys.argv[2][1:]))
action = params['action']

# 获取电影列表
if action == 'find':
	title = params['title'].strip()

	item = xbmcgui.ListItem()
	item.setLabel(title)
	item_url = title

	xbmcplugin.addDirectoryItem(pHandle, item_url, item, True)

# 获取电影资料
elif action == 'getdetails':
	title = params['url']
	settings = json.loads(params['pathSettings'])
	infoLabels = {
		'title': title, # The title for the movie
#		'originaltitle': '', # Displays the original title of the movie
#		'sorttitle': '', # Allows alternate title sort without modifying movie title
#		'rating': 0, # rating
#		'votes': 0, # votes
#		'userrating': 0, # Personal rating set by the user
#		'top250': 0, # Ranking in IMDB Top 250 movies
#		'plotoutline': '', # Should be short, will be displayed on a single line
#		'plot': '', # Can contain more information on multiple lines, will be wrapped
#		'tagline': '', # Short movie slogan
#		'duration': 0, # If ommitted, Kodi will add runtime upon scanning
#		'mpaa': '', # Country specific mpaa rating system
#		'playcount': 0, # Number of times movie has been played
#		'lastplayed': '', # Date last played as yyyy-mm-dd
		'genre': settings['genre'].split('|'),
		'tag': settings['tag'].split('|'), # Library Tags
#		'setid': 0, # setid
		'set': settings['set'], # Movie set tags
#		'setoverview': '', # tag allows a short summary of the movie set
		'country': settings['country'].split('|'), # Country of origin
		'credits': settings['credits'].split('|'), # Field for writers
		'writer': settings['credits'].split('|'), # Field for writers
		'director': settings['director'].split('|'), # Movie Director
#		'cast': [], # Movie Cast
#		'castandrole': [], # Movie Cast and Role
		'premiered': settings['premiered'], # Release date of movie. Format as yyyy-mm-dd
#		'year': 0, # Release Year
		'studio': settings['studio'].split('|'), # Production studio
#		'trailer': '', # Local or online path to movie trailer
#		'showlink': '', # Connect movie to TV Show. Use the TV Show <title></title> name.
#		'dateadded': '', # mTime of the playable video file
		'mediatype': 'movie'}

	poster = getArtworks(settings['posterDir'], title, 'poster')
	fanart = getArtworks(settings['fanartDir'], title, 'fanart')
	actors = getActors(settings['cast'].split('|'))

	item = xbmcgui.ListItem()
	item.setInfo('video', infoLabels) # movie
	item.addAvailableArtwork(poster, 'poster') # Path to available Movie Posters
	item.addAvailableArtwork(fanart, 'fanart') # Path to available movie fanart
	item.setCast(actors) # actor

	xbmcplugin.setResolvedUrl(pHandle, True, item)

# 从本地获取电影信息
elif action == 'nfourl':
	pass

xbmcplugin.endOfDirectory(pHandle)