from spider import SpiderItemType, SpiderItem
from spider_aliyundrive import SpiderAliyunDrive
from utils import get_image_path
import requests
import xbmcaddon

_ADDON = xbmcaddon.Addon()


headers = {
    'Accept-Language': 'zh-CN,zh;q=0.9,en;q=0.8,ja;q=0.7',
}

class SpiderGitCafe(SpiderAliyunDrive):

    def name(self):
        return '小纸条'

    def logo(self):
        return get_image_path('gitcafe.png')

    def hide(self):
        return not _ADDON.getSettingBool('data_source_gitcafe_switch')

    def is_searchable(self):
        return True

    def list_items(self, parent_item=None, page=1):
        if parent_item is None:
            items = []
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id='hydm',
                    name='华语动漫',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="hyds",
                    name='华语电视',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="hydy",
                    name='华语电影',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="omdm",
                    name='欧美动漫',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="omds",
                    name='欧美电视',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="omdy",
                    name='欧美电影',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="rhdm",
                    name='日韩动漫',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="rhds",
                    name='日韩电视',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="rhdy",
                    name='日韩电影',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="qtds",
                    name='其他电视',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="qtdy",
                    name='其他电影',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="qtsp",
                    name='其他视频',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="jlp",
                    name='纪录片',
                ))
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id="zyp",
                    name='综艺片',
                ))
            return items, False
        elif not parent_item['id'].startswith('http'):
            r = requests.post(
                'https://gitcafe.net/tool/alipaper/',
                data={
                    'action': 'viewcat',
                    'cat': parent_item['id'],
                    'num': page,
                },
            )
            data = r.json()

            items = []
            for video in data:
                items.append(
                    SpiderItem(
                        type=SpiderItemType.Directory,
                        id='https://www.aliyundrive.com/s/' + video['key'],
                        name=video['title'],
                    ))

            return items, len(items) >= 50
        else:
            return super().list_items(parent_item, page)

    def search(self, keyword):
        r = requests.post(
            'https://gitcafe.net/tool/alipaper/',
            data={
                'action': 'search',
                'keyword': keyword,
            },
            headers=headers,
        )
        data = r.json()

        items = []
        for video in data:
            items.append(
                SpiderItem(
                    type=SpiderItemType.Directory,
                    id='https://www.aliyundrive.com/s/' + video['key'],
                    name=video['title'],
                ))

        return items
