from http.server import BaseHTTPRequestHandler, HTTPServer
from urllib.parse import urlencode, urlparse, parse_qs
from threading import Thread
import requests
import json
import xbmc

host = "localhost"
port = 10789


class ProxyType(object):
    TEST = 'test'
    MAIN = 'main'
    SUB = 'sub'


def get_proxy_url(type, url, headers):
    return 'http://{}:{}?'.format(host, port) + urlencode(
        {
            'type': type,
            'url': url,
            'headers': json.dumps(headers),
        })


class ProxyServer(BaseHTTPRequestHandler):

    def do_GET(self):
        params = parse_qs(urlparse(self.path).query)
        type = params['type'][0]
        url = params['url'][0]
        headers = json.loads(
            params['headers'][0]) if 'headers' in params else {}

        if type == 'test':
            self.send_response(200)
            self.end_headers()
            return

        r = requests.get(url, headers=headers, stream=True)
        content_type = r.headers['content-type']
        if type == 'main':
            if content_type.startswith('image/'):
                content_type = 'application/vnd.apple.mpegurl'
        if type == 'sub':
            content_type = 'video/MP2T'

        self.send_response(200)
        self.send_header("Content-type", content_type)
        self.end_headers()

        try:
            if content_type == 'application/vnd.apple.mpegurl':
                for line in r.iter_lines(8192):
                    line = line.decode()
                    if len(line) > 0 and not line.startswith('#'):
                        if not line.startswith('http'):
                            if line.startswith('/'):
                                line = url[:url.index('/', 8)] + line
                            else:
                                line = url[:url.rindex('/') + 1] + line
                        line = get_proxy_url(ProxyType.SUB, line, headers)
                    self.wfile.write(line.encode())
                    self.wfile.write('\n'.encode())
            else:
                stripped_fake_header = False
                for chunk in r.iter_content(8192):
                    if not stripped_fake_header:
                        chunk = chunk.lstrip(
                            b'\x89\x50\x4E\x47\x0D\x0A\x1A\x0A')
                        stripped_fake_header = True
                    self.wfile.write(chunk)
        except Exception as e:
            print(e)
            try:
                r.close()
            except:
                pass


if __name__ == "__main__":

    def serve_forever():
        try:
            print("Proxy Server started http://%s:%s" % (host, port))
            HTTPServer((host, port), ProxyServer).serve_forever()
        except Exception as e:
            print(e)
            print("Proxy Server stopped.")

    thread = Thread(target=serve_forever)
    thread.daemon = True
    thread.start()

    monitor = xbmc.Monitor()
    while not monitor.abortRequested():
        if monitor.waitForAbort(10):
            break
