# -*- coding: utf-8 -*-
# Module: default
# Author: Roman V. M.
# Created on: 28.11.2014
# License: GPL v.3 https://www.gnu.org/copyleft/gpl.html


import re
from xbmcswift2 import Plugin
import requests
from bs4 import BeautifulSoup
import xbmcgui

plugin = Plugin()



headers = {'user-agent': 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_0_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12A366 Safari/600.1.4'}

def get_categories():
    return [{'name':'首页','link':'https://www.66s.cc/'},
            {'name':'喜剧片','link':'https://www.66s.cc/xijupian/'},
            {'name':'动作片','link':'https://www.66s.cc/dongzuopian/'},
            {'name':'爱情片','link':'https://www.66s.cc/aiqingpian/'},
            {'name':'科幻片','link':'https://www.66s.cc/kehuanpian/'},
            {'name':'恐怖片','link':'https://www.66s.cc/kongbupian/'},
            {'name':'剧情片','link':'https://www.66s.cc/juqingpian/'},
            {'name':'战争片','link':'https://www.66s.cc/zhanzhengpian/'},
            {'name':'纪录片','link':'https://www.66s.cc/jilupian/'},
            {'name':'动画片','link':'https://www.66s.cc/donghuapian/'},
            {'name':'电视剧','link':'https://www.66s.cc/dianshiju/'},
            {'name':'福利','link':'https://www.66s.cc/fuli/'},
            {'name':'综艺','link':'https://www.66s.cc/ZongYi/'}]


def get_videos(category,page):
    if int(page) == 1:
        pageurl = category
    else:
        pageurl = category + 'index_'+page+'.html'

    r = requests.get(pageurl, headers=headers)
    r.encoding = 'UTF-8'
    soup = BeautifulSoup(r.text)
    videos = []
    videoelements=soup.select("li.post.box.row.fixed-hight")

    if videoelements is None:
        dialog = xbmcgui.Dialog()
        ok = dialog.ok('错误提示', '没有播放源')
    else:
        for videoelement in videoelements:
            videoitem = {}
            videoitem['name'] = videoelement.find('a', class_='zoom')['title']
            videoitem['href'] = videoelement.find('a', class_='zoom')['href']
            videoitem['thumb'] = videoelement.find('img')['src']
            videoitem['genre'] = '喜剧片'
            videos.append(videoitem)
        return videos




def get_sources(videolink):
    r = requests.get(videolink, headers=headers)
    r.encoding = 'UTF-8'
    soup = BeautifulSoup(r.text)
    sources = []
    categoryname = soup.find('span',class_='info_category info_ico').find('a').get_text()
    sourcetitle = soup.find('div', class_='context').find('h3', text='播放地址（无需安装插件）')
    thumbimg = soup.find('div', class_='context').find('img')['src']
    if sourcetitle is not None:
        sourcecontenter = sourcetitle.parent
        sourceitems = sourcecontenter.find_all('a')
        for sourceitem in sourceitems:
            videosource = {}
            videosource['name'] = sourceitem['title']
            videosource['thumb'] = thumbimg
            videosource['category'] = categoryname
            videosource['href'] = sourceitem['href']
            sources.append(videosource)
        return sources
    else:
        dialog = xbmcgui.Dialog()
        ok = dialog.ok('错误提示', '没有播放源')



@plugin.route('/play/<url>/')
def play(url):
    r = requests.get(url, headers=headers)
    r.encoding = 'UTF-8'
    pattern = re.compile("a:\'(.*)\'")
    playurl = pattern.findall(r.text)[0]

    item = {'label': '播放','path': playurl,'is_playable': True}
    items = []
    items.append(item)
    return items
    
    # if playurl is not None:
    #     plugin.set_resolved_url(item)
    # else:
    #     dialog = xbmcgui.Dialog()
    #     ok = dialog.ok('错误提示', '没有播放源')


@plugin.route('/sources/<url>/')
def sources(url):
    sources = get_sources(url)
    items = [{
        'label': source['name'],
        'path': plugin.url_for('play', url=source['href']),
        'thumbnail': source['thumb'],
        'icon': source['thumb'],
    } for source in sources]
    sorted_items = sorted(items, key=lambda item: item['label'])
    return sorted_items


@plugin.route('/category/<url>/<page>/')
def category(url,page):
    videos = get_videos(url, page)
    items = [{
        'label': video['name'],
        'path': plugin.url_for('sources', url=video['href']),
        'thumbnail': video['thumb'],
        'icon': video['thumb']
    } for video in videos]
    sorted_items = items
    #sorted_items = sorted(items, key=lambda item: item['label'])
    pageno = int(page) + 1
    nextpage = {'label': ' 下一页','path': plugin.url_for('category', url=url,page=pageno)}
    sorted_items.append(nextpage)
    return sorted_items


@plugin.route('/')
def index():
    categories = get_categories()
    items = [{
        'label': category['name'],
        'path': plugin.url_for('category', url=category['link'],page=1),
    } for category in categories]
    #sorted_items = sorted(items, key=lambda item: item['label'])
    return items


if __name__ == '__main__':
    plugin.run()
    plugin.set_view_mode(500)
